/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.io;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;

public class StreamUtil {
    public static final int BUFFER_SIZE = 4096;

    public static byte[] copyToByteArray(InputStream in) {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        StreamUtil.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static String copyToString(InputStream in, Charset charset) {
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[4096];
        try {
            int bytesRead = -1;
            while ((bytesRead = reader.read(buffer)) != -1) {
                out.append(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            throw new BizRuntimeException(ex);
        }
        return out.toString();
    }

    public static void copy(byte[] in, OutputStream out) {
        Objects.requireNonNull(in, "No input byte array specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        try {
            out.write(in);
        }
        catch (IOException ex) {
            throw new BizRuntimeException(ex);
        }
    }

    public static void copy(String in, Charset charset, OutputStream out) {
        Objects.requireNonNull(in, "No input String specified");
        Objects.requireNonNull(charset, "No charset specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        try {
            writer.write(in);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            throw new BizRuntimeException(ex);
        }
    }

    public static int copy(InputStream in, OutputStream out) {
        Objects.requireNonNull(in, "No InputStream specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        try {
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
        }
        catch (IOException ex) {
            throw new BizRuntimeException(ex);
        }
        return byteCount;
    }

    private StreamUtil() {
    }
}

