/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.base;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class DateTimeFormatUtils {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMM = "yyyyMM";
    public static final String HH_MM_SS = "HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER_CN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER_EN = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter DATE_FORMATTER_EN = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter YEAR_MONTH_FORMATTER_EN = DateTimeFormatter.ofPattern("yyyyMM");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Calendar toCalendar(LocalDateTime localDateTime) {
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return DateTimeFormatUtils.toCalendar(zonedDateTime);
    }

    public static Calendar toCalendar(LocalDate localDate) {
        return DateTimeFormatUtils.toCalendar(localDate.atStartOfDay());
    }

    public static Calendar toCalendar(ZonedDateTime zonedDateTime) {
        TimeZone timeZone = TimeZone.getTimeZone(zonedDateTime.getZone());
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        return calendar;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static ZonedDateTime toZonedDateTime(Calendar calendar) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(calendar.getTimeInMillis()), calendar.getTimeZone().toZoneId());
    }

    public static String print2DateTimeCN(Date date) {
        return date != null ? DATE_TIME_FORMATTER_CN.format(date.toInstant().atZone(ZoneId.systemDefault())) : null;
    }

    public static String print2DateTimeCN(LocalDateTime date) {
        return date != null ? DATE_TIME_FORMATTER_CN.format(date) : null;
    }

    public static Date parse2DateTimeCN(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        LocalDateTime localDateTime = LocalDateTime.parse(date, DATE_TIME_FORMATTER_CN);
        return DateTimeFormatUtils.toDate(localDateTime);
    }

    public static LocalDateTime parseToDateTimeCN(String date) {
        return StringUtils.isNotBlank((CharSequence)date) ? LocalDateTime.parse(date, DATE_TIME_FORMATTER_CN) : null;
    }

    public static String print2Date(Date date) {
        return date != null ? DATE_FORMATTER.format(date.toInstant().atZone(ZoneId.systemDefault())) : null;
    }

    public static String print2Date(LocalDateTime date) {
        return date != null ? DATE_FORMATTER.format(date) : null;
    }

    public static Date parse2Date(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        LocalDate localDate = LocalDate.parse(date, DATE_FORMATTER);
        return DateTimeFormatUtils.toDate(localDate);
    }

    public static LocalDate parseToDate(String date) {
        return StringUtils.isNotBlank((CharSequence)date) ? LocalDate.parse(date, DATE_FORMATTER) : null;
    }

    public static String print2DateTimeEN(Date date) {
        return date != null ? DATE_TIME_FORMATTER_EN.format(date.toInstant().atZone(ZoneId.systemDefault())) : null;
    }

    public static String print2DateTimeEN(LocalDateTime date) {
        return date != null ? DATE_TIME_FORMATTER_EN.format(date) : null;
    }

    public static Date parse2DateTimeEN(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        LocalDateTime localDateTime = LocalDateTime.parse(date, DATE_TIME_FORMATTER_EN);
        return DateTimeFormatUtils.toDate(localDateTime);
    }

    public static LocalDateTime parseToDateTimeEN(String date) {
        return StringUtils.isNotBlank((CharSequence)date) ? LocalDateTime.parse(date, DATE_TIME_FORMATTER_EN) : null;
    }

    public static String print2DateEN(Date date) {
        return date != null ? DATE_FORMATTER_EN.format(date.toInstant().atZone(ZoneId.systemDefault())) : null;
    }

    public static String print2DateEN(LocalDate date) {
        return date != null ? DATE_FORMATTER_EN.format(date) : null;
    }

    public static String print2DateEN(LocalDateTime date) {
        return date != null ? DATE_FORMATTER_EN.format(date) : null;
    }

    public static Date parse2DateEN(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        LocalDate localDateTime = LocalDate.parse(date, DATE_FORMATTER_EN);
        return DateTimeFormatUtils.toDate(localDateTime);
    }

    public static LocalDateTime parseToDateEN(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDate.parse(date, DATE_FORMATTER_EN).atStartOfDay();
    }

    public static String print2YearMonth(Date date) {
        return date != null ? YEAR_MONTH_FORMATTER_EN.format(date.toInstant().atZone(ZoneId.systemDefault())) : null;
    }

    public static String print2YearMonth(LocalDate date) {
        return date != null ? YEAR_MONTH_FORMATTER_EN.format(date) : null;
    }

    public static String print2YearMonth(LocalDateTime date) {
        return date != null ? YEAR_MONTH_FORMATTER_EN.format(date) : null;
    }

    public static Date parse2YearMonth(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        YearMonth yearMonth = YearMonth.parse(date, YEAR_MONTH_FORMATTER_EN);
        LocalDateTime localDateTime = yearMonth.atDay(1).atStartOfDay();
        return DateTimeFormatUtils.toDate(localDateTime);
    }

    public static LocalDateTime parseToYearMonth(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        YearMonth yearMonth = YearMonth.parse(date, YEAR_MONTH_FORMATTER_EN);
        return yearMonth.atDay(1).atStartOfDay();
    }

    public static String print2Time(Date date) {
        return date != null ? TIME_FORMATTER.format(date.toInstant().atZone(ZoneId.systemDefault())) : null;
    }

    public static String print2Time(LocalDateTime date) {
        return date != null ? TIME_FORMATTER.format(date) : null;
    }

    public static boolean checkDateTimeOverlap(Date srcEffectiveTime, Date srcExpiryTime, Date targetEffectiveTime, Date targetExpiryTime) {
        return !srcEffectiveTime.after(targetExpiryTime) && !srcExpiryTime.before(targetEffectiveTime);
    }

    public static boolean checkDateTimeOverlap(LocalDateTime srcEffectiveTime, LocalDateTime srcExpiryTime, LocalDateTime targetEffectiveTime, LocalDateTime targetExpiryTime) {
        return !srcEffectiveTime.isAfter(targetExpiryTime) && !srcExpiryTime.isBefore(targetEffectiveTime);
    }

    public static Date withTimeAtStartOfDay(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay();
        return DateTimeFormatUtils.toDate(localDateTime);
    }

    public static Date withTimeAtStartOfDay(LocalDateTime date) {
        Instant instant = date.toLocalDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date withTimeAtEndOfDay(Date date) {
        Instant instant = date.toInstant().atZone(ZoneId.systemDefault()).with(LocalTime.MAX).toInstant();
        return Date.from(instant);
    }

    public static Date withTimeAtEndOfDay(LocalDateTime date) {
        Instant instant = date.atZone(ZoneId.systemDefault()).with(LocalTime.MAX).toInstant();
        return Date.from(instant);
    }

    public static Date withTimeAtEndOfDayAndRemoveNano(LocalDateTime date) {
        Instant instant = date.atZone(ZoneId.systemDefault()).with(LocalTime.MAX).withNano(0).toInstant();
        return Date.from(instant);
    }

    public static Date withTimeAtEndOfDayAndRemoveNano(Date date) {
        Instant instant = date.toInstant().atZone(ZoneId.systemDefault()).with(LocalTime.MAX).withNano(0).toInstant();
        return Date.from(instant);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return date1 == null && date2 == null || date1 != null && date2 != null && date1.equals(date2);
    }

    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return date1 == null && date2 == null || date1 != null && date2 != null && date1.isEqual(date2);
    }
}

