/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.utils.ProxyTargetUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class ProxyClassUtils {
    public static boolean checkIsProxy(Object proxy) {
        if (proxy == null) {
            return false;
        }
        return AopUtils.isAopProxy((Object)proxy) || Proxy.isProxyClass(proxy.getClass());
    }

    public static Class<?> getClass(Object proxy) {
        Class<?>[] classes = ProxyClassUtils.getClasses(proxy);
        return classes != null ? classes[0] : null;
    }

    public static Class<?>[] getClasses(Object proxy) {
        try {
            if (proxy == null) {
                return null;
            }
            if (AopUtils.isAopProxy((Object)proxy)) {
                AdvisedSupport advisedSupport = AopUtils.isJdkDynamicProxy((Object)proxy) ? ProxyClassUtils.getAopJdkDynamicProxyAdvised(proxy) : ProxyClassUtils.getAopCglibProxyAdvised(proxy);
                Object target = advisedSupport.getTargetSource().getTarget();
                if (!ProxyClassUtils.checkIsProxy(target)) {
                    return ProxyClassUtils.getAopProxyInterfaces(advisedSupport);
                }
                return ProxyClassUtils.getClasses(target);
            }
            if (Proxy.isProxyClass(proxy.getClass())) {
                Object target = ProxyTargetUtils.getJdkProxyTargetObject(proxy);
                if (!ProxyClassUtils.checkIsProxy(target)) {
                    return ProxyClassUtils.getJdkProxyInterfaces(proxy);
                }
                return ProxyClassUtils.getClasses(target);
            }
            return proxy.getClass().getInterfaces();
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    public static AdvisedSupport getAopCglibProxyAdvised(Object proxy) {
        try {
            Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
            h.setAccessible(true);
            Object dynamicAdvisedInterceptor = h.get(proxy);
            Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return (AdvisedSupport)advised.get(dynamicAdvisedInterceptor);
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    public static AdvisedSupport getAopJdkDynamicProxyAdvised(Object proxy) {
        try {
            Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
            h.setAccessible(true);
            AopProxy aopProxy = (AopProxy)h.get(proxy);
            Field advised = aopProxy.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return (AdvisedSupport)advised.get(aopProxy);
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    public static Class<?>[] getAopProxyInterfaces(AdvisedSupport advisedSupport) {
        try {
            if (advisedSupport.getTargetSource().getTarget().getClass().isInterface()) {
                return advisedSupport.getProxiedInterfaces();
            }
            return new Class[]{advisedSupport.getTargetClass()};
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    public static Class<?>[] getJdkProxyInterfaces(Object proxy) {
        return proxy.getClass().getInterfaces();
    }

    private ProxyClassUtils() {
    }
}

