/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.spring.boot.config;

import app.myoss.cloud.core.constants.MyossConstants;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={FastJsonConfig.class})
@ConditionalOnWebApplication
@Configuration
public class FastJsonAutoConfiguration {
    public static FastJsonConfig fastJsonConfig() {
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteMapNullValue});
        fastJsonConfig.setCharset(MyossConstants.DEFAULT_CHARSET);
        return fastJsonConfig;
    }

    @ConditionalOnMissingBean(name={"defaultFastJsonConfig"})
    @Bean(name={"defaultFastJsonConfig"})
    public FastJsonConfig defaultFastJsonConfig() {
        return FastJsonAutoConfiguration.fastJsonConfig();
    }
}

