/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.bean;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BeanUtil {
    public static <T> T methodInvoke(Method method, Object target, Object ... args) {
        try {
            return (T)method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BizRuntimeException(e);
        }
    }

    public static void copyProperties(Object source, Object target, @Nullable Class<?> editable, boolean overrideNotBlankProperty, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (!overrideNotBlankProperty) {
                Method readMethod2 = targetPd.getReadMethod();
                try {
                    Object value = readMethod2.invoke(target, new Object[0]);
                    if (value != null && (value instanceof CharSequence ? StringUtils.isNotBlank((CharSequence)((CharSequence)value)) : (value instanceof Collection ? !((Collection)value).isEmpty() : !(value instanceof Map) || !((Map)value).isEmpty()))) {
                        continue;
                    }
                }
                catch (Throwable ex) {
                    throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
                }
            }
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Class<?> cls;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!overrideNotBlankProperty && value == null && (Collection.class.isAssignableFrom(cls = writeMethod.getParameterTypes()[0]) || Map.class.isAssignableFrom(cls))) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }
}

