/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.utils;

import java.security.SecureRandom;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomUtils {
    private static final Logger log = LoggerFactory.getLogger(RandomUtils.class);
    public static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String buildSequenceNo(long nextValue, int length) {
        String value = String.valueOf(nextValue);
        if (value.length() <= length) {
            return StringUtils.leftPad((String)value, (int)length, (char)'0');
        }
        int intValue = Math.toIntExact(nextValue);
        long nextRandom = SECURE_RANDOM.nextInt(intValue);
        String tmp = String.valueOf(nextRandom);
        int tmpLength = tmp.length() - 1;
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int r = SECURE_RANDOM.nextInt(tmpLength);
            builder.append(tmp.substring(r));
            if (builder.length() >= length) break;
        }
        if (builder.length() > length) {
            return builder.subSequence(0, length).toString();
        }
        return builder.toString();
    }
}

