/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.json.JsonObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;

public class JacksonMapper {
    public static TypeReference<SortedMap<String, String>> SORTED_MAP_S2S_TYPE_REFERENCE = new TypeReference<SortedMap<String, String>>(){};
    public static TypeReference<LinkedHashMap<String, Object>> LINKED_HASH_MAP_S2O_TYPE_REFERENCE = new TypeReference<LinkedHashMap<String, Object>>(){};
    public static TypeReference<JsonObject> JSON_OBJECT_TYPE_REFERENCE = new TypeReference<JsonObject>(){};
    private ObjectMapper mapper = new ObjectMapper();

    public JacksonMapper() {
        this(null);
    }

    public JacksonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static JacksonMapper nonNullMapper() {
        return new JacksonMapper(JsonInclude.Include.NON_NULL);
    }

    public static JacksonMapper nonEmptyMapper() {
        return new JacksonMapper(JsonInclude.Include.NON_EMPTY);
    }

    public static JacksonMapper nonDefaultMapper() {
        return new JacksonMapper(JsonInclude.Include.NON_DEFAULT);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new BizRuntimeException("write to json string error:" + object, e);
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            throw new BizRuntimeException("parse json string error:" + jsonString, e);
        }
    }

    public <T> T fromJson(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw new BizRuntimeException("parse json string error:" + jsonString, e);
        }
    }

    public <T> T fromJson(String jsonString, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw new BizRuntimeException("parse json string error:" + jsonString, e);
        }
    }

    public JsonObject fromJson(String jsonString) {
        return this.fromJson(jsonString, JSON_OBJECT_TYPE_REFERENCE);
    }

    public JsonObject json2Map(String json) {
        return this.fromJson(json, JsonObject.class);
    }

    public <T> T convert(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        return (T)this.mapper.convertValue(object, clazz);
    }

    public <T> T convert(Object object, JavaType toValueType) {
        if (object == null) {
            return null;
        }
        return (T)this.mapper.convertValue(object, toValueType);
    }

    public <T> T convert(Object object, TypeReference<T> toValueTypeRef) {
        if (object == null) {
            return null;
        }
        return (T)this.mapper.convertValue(object, toValueTypeRef);
    }

    public JavaType constructCollectionType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return this.mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }

    public JavaType constructMapType(Class<? extends Map> mapClass, Class<?> keyClass, Class<?> valueClass) {
        return this.mapper.getTypeFactory().constructMapType(mapClass, keyClass, valueClass);
    }

    public void update(String jsonString, Object object) {
        try {
            this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (IOException e) {
            throw new BizRuntimeException("update json string:" + jsonString + " to object:" + object + " error.", e);
        }
    }

    public String toJsonP(String functionName, Object object) {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public void enableEnumUseToString() {
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

