/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.base;

import java.math.BigDecimal;
import java.util.Objects;

public final class ParsedNumber
extends Number {
    private static final long serialVersionUID = 6655538761473723478L;
    private final String value;

    public ParsedNumber(String value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            try {
                return (int)Long.parseLong(this.value);
            }
            catch (NumberFormatException nfe) {
                return new BigDecimal(this.value).intValue();
            }
        }
    }

    @Override
    public long longValue() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException e) {
            return new BigDecimal(this.value).longValue();
        }
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.value);
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.value);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParsedNumber) {
            ParsedNumber other = (ParsedNumber)obj;
            return Objects.equals(this.value, other.value);
        }
        return false;
    }
}

