/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.serializer.impl;

import app.myoss.cloud.core.lang.serializer.Serialization;
import app.myoss.cloud.core.lang.serializer.SerializationException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;

public class JdkSerialization
implements Serialization<Object> {
    private Converter<Object, byte[]> serializer = new SerializingConverter();
    private Converter<byte[], Object> deserializer = new DeserializingConverter();
    static final byte[] EMPTY_ARRAY = new byte[0];

    static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    @Override
    public byte[] serialize(Object object) {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        try {
            return (byte[])this.serializer.convert(object);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize", ex);
        }
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (JdkSerialization.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.deserializer.convert((Object)bytes);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize", ex);
        }
    }
}

