/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class ProxyTargetUtils {
    public static Object getTarget(Object proxy) {
        if (proxy == null) {
            return null;
        }
        if (AopUtils.isAopProxy((Object)proxy)) {
            if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
                Object target = ProxyTargetUtils.getAopJdkDynamicProxyTargetObject(proxy);
                return ProxyTargetUtils.getTarget(target);
            }
            Object target = ProxyTargetUtils.getAopCglibProxyTargetObject(proxy);
            return ProxyTargetUtils.getTarget(target);
        }
        if (Proxy.isProxyClass(proxy.getClass())) {
            Object target = ProxyTargetUtils.getJdkProxyTargetObject(proxy);
            return ProxyTargetUtils.getTarget(target);
        }
        return proxy;
    }

    public static Object getAopCglibProxyTargetObject(Object proxy) {
        try {
            Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
            h.setAccessible(true);
            Object dynamicAdvisedInterceptor = h.get(proxy);
            Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    public static Object getAopJdkDynamicProxyTargetObject(Object proxy) {
        try {
            Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
            h.setAccessible(true);
            AopProxy aopProxy = (AopProxy)h.get(proxy);
            Field advised = aopProxy.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    public static Object getJdkProxyTargetObject(Object proxy) {
        try {
            Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
            h.setAccessible(true);
            return h.get(proxy);
        }
        catch (Exception e) {
            throw new BizRuntimeException(e);
        }
    }

    private ProxyTargetUtils() {
    }
}

