/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.dto;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Direction {
    ASC,
    DESC;

    private static final Logger log;

    public static Direction fromString(String value) {
        try {
            return Direction.valueOf(value.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
        }
    }

    public static Direction fromStringOrNull(String value) {
        try {
            return value != null ? Direction.fromString(value) : null;
        }
        catch (IllegalArgumentException e) {
            log.warn("IllegalArgumentException", (Throwable)e);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(Direction.class);
    }
}

