/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.constants;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum DeployEnvEnum {
    DEV("dev", "\u5f00\u53d1\u73af\u5883"),
    TEST("test", "\u6d4b\u8bd5\u73af\u5883"),
    PRE("pre", "\u9884\u53d1\u73af\u5883"),
    PRD("prd", "\u751f\u4ea7\u73af\u5883");

    private String value;
    private String name;
    private static String CURRENT_ENV;

    public static DeployEnvEnum getEnumByValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        for (DeployEnvEnum item : DeployEnvEnum.values()) {
            if (!Objects.equals(item.getValue(), value)) continue;
            return item;
        }
        return null;
    }

    public static boolean isDevOrTest(String value) {
        return DEV.getValue().equals(value) || TEST.getValue().equals(value);
    }

    public static boolean isDevOrTest() {
        String value = DeployEnvEnum.getDeployEnv();
        return DEV.getValue().equals(value) || TEST.getValue().equals(value);
    }

    public static boolean isDev(String value) {
        return DEV.getValue().equals(value);
    }

    public static boolean isDev() {
        String value = DeployEnvEnum.getDeployEnv();
        return DEV.getValue().equals(value);
    }

    public static boolean isTest(String value) {
        return TEST.getValue().equals(value);
    }

    public static boolean isTest() {
        String value = DeployEnvEnum.getDeployEnv();
        return TEST.getValue().equals(value);
    }

    public static boolean isPre(String value) {
        return PRE.getValue().equals(value);
    }

    public static boolean isPre() {
        String value = DeployEnvEnum.getDeployEnv();
        return PRE.getValue().equals(value);
    }

    public static boolean isPrd(String value) {
        return PRD.getValue().equals(value);
    }

    public static boolean isPrd() {
        String value = DeployEnvEnum.getDeployEnv();
        return PRD.getValue().equals(value);
    }

    public static String getDeployEnv() {
        if (CURRENT_ENV == null) {
            CURRENT_ENV = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty("DEPLOY_ENV"), (CharSequence)System.getenv("DEPLOY_ENV"));
        }
        return CURRENT_ENV;
    }

    public static DeployEnvEnum getDeployEnvEnum() {
        String deployEnv = DeployEnvEnum.getDeployEnv();
        return DeployEnvEnum.getEnumByValue(deployEnv);
    }

    private DeployEnvEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

