/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.spring.boot.config;

import app.myoss.cloud.core.constants.DeployEnvEnum;
import app.myoss.cloud.core.spring.boot.config.CoreCommonEnvironmentPostProcessor;
import app.myoss.cloud.core.utils.YamlUtils;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DeployEnvEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
SmartApplicationListener {
    private static final DeferredLog LOGGER = new DeferredLog();
    public static final int DEFAULT_ORDER = -2147483630;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ClassPathResource path = new ClassPathResource("core-config/service-deploy-env.yml");
        LinkedHashMap<String, Object> linkedHashMap = YamlUtils.loadYaml2Map((Resource)path);
        if (linkedHashMap != null) {
            String customizeDev = (String)linkedHashMap.get(DeployEnvEnum.CUSTOMIZE_DEV.getValue());
            if (StringUtils.isNotBlank((CharSequence)customizeDev)) {
                LOGGER.info((Object)("DEPLOY_ENV_CUSTOMIZE_DEV set to " + customizeDev));
                System.setProperty(DeployEnvEnum.CUSTOMIZE_DEV.getValue(), customizeDev);
                String deployEnv = DeployEnvEnum.getDeployEnv();
                if (deployEnv == null) {
                    deployEnv = environment.getProperty("DEPLOY_ENV");
                }
                if (deployEnv == null) {
                    LOGGER.info((Object)("DEPLOY_ENV set to " + customizeDev));
                    DeployEnvEnum.setDeployEnv(customizeDev);
                }
            }
            CoreCommonEnvironmentPostProcessor.addOrReplace(environment.getPropertySources(), linkedHashMap);
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            LOGGER.replayTo(DeployEnvEnvironmentPostProcessor.class);
        }
    }

    public int getOrder() {
        return -2147483630;
    }
}

