/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.spring.context;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Scope(scopeName="singleton")
public class SpringContextHolder {
    private static final Logger log = LoggerFactory.getLogger(SpringContextHolder.class);
    private static ApplicationContext APPLICATION_CONTEXT = null;

    @EventListener
    public static void setApplicationContext(ApplicationReadyEvent event) {
        APPLICATION_CONTEXT = event.getApplicationContext();
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return APPLICATION_CONTEXT;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)APPLICATION_CONTEXT.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)APPLICATION_CONTEXT.getBean(name, requiredType);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)APPLICATION_CONTEXT.getBean(requiredType);
    }

    public static boolean containsBean(String name) {
        SpringContextHolder.assertContextInjected();
        return APPLICATION_CONTEXT.containsBean(name);
    }

    public static boolean containsBeanDefinition(String beanName) {
        SpringContextHolder.assertContextInjected();
        return APPLICATION_CONTEXT.containsBeanDefinition(beanName);
    }

    public static boolean containsLocalBean(String name) {
        return APPLICATION_CONTEXT.containsLocalBean(name);
    }

    private static void assertContextInjected() {
        Objects.requireNonNull(APPLICATION_CONTEXT, "\u8bf7\u68c0\u67e5\uff0capplicationContext\u5c5e\u6027\u672a\u6ce8\u5165.");
    }

    private SpringContextHolder() {
    }
}

