/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.utils;

import app.myoss.cloud.core.lang.base.DateTimeFormatUtils;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardUtils {
    private static final Logger log = LoggerFactory.getLogger(IdCardUtils.class);
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final int MIN = 1930;
    private static final ImmutableMap<String, String> CITY_CODE;
    private static final ImmutableMap<String, Integer> TW_FIRST_CODE;
    private static final ImmutableMap<String, Integer> HK_FIRST_CODE;
    public static final Pattern MO_CARD_PATTERN;
    public static final String MALE = "M";
    public static final String FEMALE = "F";
    public static final String UN_KNOW = "N";

    public static ImmutableMap<String, String> getCityCode() {
        return CITY_CODE;
    }

    public static ImmutableMap<String, Integer> getTwFirstCode() {
        return TW_FIRST_CODE;
    }

    public static ImmutableMap<String, Integer> getHkFirstCode() {
        return HK_FIRST_CODE;
    }

    public static String convertCard15To18(String idCard) {
        String sVal;
        String idCard18 = "";
        if (idCard == null) {
            return idCard18;
        }
        if (idCard.length() != 15) {
            return null;
        }
        if (IdCardUtils.isNum(idCard)) {
            LocalDateTime birthDate;
            String birthday = idCard.substring(6, 12);
            try {
                birthDate = DateTimeFormatUtils.parseToDateEN("19" + birthday);
                Objects.requireNonNull(birthDate);
            }
            catch (Exception e) {
                log.warn(birthday + " parse to localDate failed", (Throwable)e);
                return null;
            }
            idCard18 = idCard.substring(0, 6) + birthDate.getYear() + idCard.substring(8);
            char[] cArr = idCard18.toCharArray();
            int[] iCard = IdCardUtils.convertCharToInt(cArr);
            int iSum17 = IdCardUtils.getPowerSum(iCard);
            sVal = IdCardUtils.getCheckCode18(iSum17);
            if (sVal.length() <= 0) {
                return null;
            }
        } else {
            return null;
        }
        idCard18 = idCard18 + sVal;
        return idCard18;
    }

    public static boolean validateCard(String idCard) {
        if (StringUtils.isBlank((CharSequence)idCard)) {
            return false;
        }
        String card = idCard.trim();
        if (IdCardUtils.validateIdCard18(card)) {
            return true;
        }
        if (IdCardUtils.validateIdCard15(card)) {
            return true;
        }
        String[] cardArray = IdCardUtils.validateIdCard10(card);
        return "true".equals(cardArray[2]);
    }

    public static boolean validateIdCard18(String idCard) {
        boolean bTrue = false;
        if (idCard == null) {
            return false;
        }
        if (idCard.length() == 18) {
            char[] cArr;
            int[] iCard;
            int iSum17;
            String val;
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (IdCardUtils.isNum(code17) && (val = IdCardUtils.getCheckCode18(iSum17 = IdCardUtils.getPowerSum(iCard = IdCardUtils.convertCharToInt(cArr = code17.toCharArray())))).equalsIgnoreCase(code18)) {
                bTrue = true;
            }
        }
        return bTrue;
    }

    public static boolean validateIdCard15(String idCard) {
        if (idCard == null) {
            return false;
        }
        if (idCard.length() != 15) {
            return false;
        }
        if (!IdCardUtils.isNum(idCard)) {
            return false;
        }
        String proCode = idCard.substring(0, 2);
        if (CITY_CODE.get((Object)proCode) == null) {
            return false;
        }
        String birthCode = idCard.substring(6, 12);
        try {
            String year = "19" + birthCode.substring(0, 2);
            LocalDate birthDate = LocalDate.of(Integer.parseInt(year), Integer.parseInt(birthCode.substring(2, 4)), Integer.parseInt(birthCode.substring(4, 6)));
            return birthDate.getYear() < 1930 || !LocalDate.now().isBefore(birthDate);
        }
        catch (Exception e) {
            log.warn(birthCode + " parse to year failed", (Throwable)e);
            return false;
        }
    }

    public static String[] validateIdCard10(String idCard) {
        String[] info = new String[3];
        if (idCard == null) {
            return info;
        }
        String card = idCard.replaceAll("[(|)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return info;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            String char2;
            info[0] = "\u53f0\u6e7e";
            switch (char2 = idCard.substring(1, 2)) {
                case "1": {
                    info[1] = MALE;
                    break;
                }
                case "2": {
                    info[1] = FEMALE;
                    break;
                }
                default: {
                    info[1] = UN_KNOW;
                    info[2] = "false";
                    return info;
                }
            }
            info[2] = IdCardUtils.validateTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = UN_KNOW;
            info[2] = IdCardUtils.validateMOCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = UN_KNOW;
            info[2] = IdCardUtils.validateHKCard(idCard) ? "true" : "false";
        } else {
            return info;
        }
        return info;
    }

    public static boolean validateTWCard(String idCard) {
        if (idCard == null) {
            return false;
        }
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        Integer iStart = (Integer)TW_FIRST_CODE.get((Object)start);
        Integer sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        Integer flag = 8;
        for (char c : chars) {
            sum = sum + Integer.parseInt(String.valueOf(c)) * flag;
            Integer n = flag;
            Integer n2 = flag = Integer.valueOf(flag - 1);
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    public static boolean validateMOCard(String idCard) {
        if (idCard == null) {
            return false;
        }
        Matcher m = MO_CARD_PATTERN.matcher(idCard);
        if (m.find()) {
            return m.group(1).length() == 1 || m.group(1).length() == 3;
        }
        return false;
    }

    public static boolean validateHKCard(String idCard) {
        Integer sum;
        if (idCard == null) {
            return false;
        }
        String card = idCard.replaceAll("[(|)]", "");
        if (card.length() == 9) {
            sum = (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        Integer flag = 7;
        for (char c : chars) {
            sum = sum + Integer.parseInt(String.valueOf(c)) * flag;
            Integer n = flag;
            Integer n2 = flag = Integer.valueOf(flag - 1);
        }
        sum = "A".equalsIgnoreCase(end) ? Integer.valueOf(sum + 10) : Integer.valueOf(sum + Integer.parseInt(end));
        return sum % 11 == 0;
    }

    public static int[] convertCharToInt(char[] ca) {
        if (ca == null) {
            return null;
        }
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return iArr;
    }

    public static int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (iArr == null) {
            return iSum;
        }
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < POWER.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * POWER[j];
                }
            }
        }
        return iSum;
    }

    public static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "X";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
                break;
            }
        }
        return sCode;
    }

    public static Date getBirthDateByIdCard(String idCard) {
        String birthVal = IdCardUtils.getBirthByIdCard(idCard);
        if (birthVal == null) {
            return null;
        }
        return DateTimeFormatUtils.parse2DateEN(birthVal);
    }

    public static String getBirthByIdCard(String idCard) {
        String idCardTemp = idCard;
        if (idCardTemp == null) {
            return null;
        }
        Integer len = idCardTemp.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCardTemp = IdCardUtils.convertCard15To18(idCardTemp);
        }
        if (idCardTemp == null) {
            return null;
        }
        return idCardTemp.substring(6, 14);
    }

    public static Short getYearByIdCard(String idCard) {
        String idCardTemp = idCard;
        if (idCardTemp == null) {
            return null;
        }
        Integer len = idCardTemp.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCardTemp = IdCardUtils.convertCard15To18(idCardTemp);
        }
        if (idCardTemp == null) {
            return null;
        }
        return Short.valueOf(idCardTemp.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        String idCardTemp = idCard;
        if (idCardTemp == null) {
            return null;
        }
        Integer len = idCardTemp.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCardTemp = IdCardUtils.convertCard15To18(idCardTemp);
        }
        if (idCardTemp == null) {
            return null;
        }
        return Short.valueOf(idCardTemp.substring(10, 12));
    }

    public static Short getDateByIdCard(String idCard) {
        String idCardTemp = idCard;
        if (idCardTemp == null) {
            return null;
        }
        Integer len = idCardTemp.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCardTemp = IdCardUtils.convertCard15To18(idCardTemp);
        }
        if (idCardTemp == null) {
            return null;
        }
        return Short.valueOf(idCardTemp.substring(12, 14));
    }

    public static String getGenderByIdCard(String idCard) {
        String idCardTemp = idCard;
        String sGender = "U";
        if (idCardTemp == null) {
            return sGender;
        }
        if (Arrays.binarySearch(new long[]{8L, 9L, 10L}, (long)idCardTemp.length()) >= 0) {
            if (idCardTemp.matches("^[a-zA-Z][0-9]{9}$")) {
                String char2 = idCardTemp.substring(1, 2);
                if ("1".equals(char2)) {
                    sGender = MALE;
                } else if ("2".equals(char2)) {
                    sGender = FEMALE;
                }
            }
            return sGender;
        }
        if (idCardTemp.length() == 15) {
            idCardTemp = IdCardUtils.convertCard15To18(idCardTemp);
        }
        if (idCardTemp != null && idCardTemp.length() >= 18) {
            String sCardNum = idCardTemp.substring(16, 17);
            sGender = Integer.parseInt(sCardNum) % 2 != 0 ? MALE : FEMALE;
        }
        return sGender;
    }

    public static String getProvinceByIdCard(String idCard) {
        if (idCard == null) {
            return null;
        }
        int len = idCard.length();
        String provinceNum = "";
        if (len == 15 || len == 18) {
            provinceNum = idCard.substring(0, 2);
        }
        return (String)CITY_CODE.get((Object)provinceNum);
    }

    public static boolean isNum(String val) {
        return val != null && !"".equals(val) && val.matches("^[0-9]*$");
    }

    private IdCardUtils() {
    }

    static {
        MO_CARD_PATTERN = Pattern.compile("^[1|5|7][0-9]{6}(\\(?[0-9]\\)?)$");
        ImmutableMap.Builder cityBuilder = ImmutableMap.builder();
        cityBuilder.put((Object)"11", (Object)"\u5317\u4eac\u5e02").put((Object)"12", (Object)"\u5929\u6d25\u5e02").put((Object)"13", (Object)"\u6cb3\u5317\u7701").put((Object)"14", (Object)"\u5c71\u897f\u7701").put((Object)"15", (Object)"\u5185\u8499\u53e4\u81ea\u6cbb\u533a").put((Object)"21", (Object)"\u8fbd\u5b81\u7701").put((Object)"22", (Object)"\u5409\u6797\u7701").put((Object)"23", (Object)"\u9ed1\u9f99\u6c5f\u7701").put((Object)"31", (Object)"\u4e0a\u6d77\u5e02").put((Object)"32", (Object)"\u6c5f\u82cf\u7701").put((Object)"33", (Object)"\u6d59\u6c5f\u7701").put((Object)"34", (Object)"\u5b89\u5fbd\u7701").put((Object)"35", (Object)"\u798f\u5efa\u7701").put((Object)"36", (Object)"\u6c5f\u897f\u7701").put((Object)"37", (Object)"\u5c71\u4e1c\u7701").put((Object)"41", (Object)"\u6cb3\u5357\u7701").put((Object)"42", (Object)"\u6e56\u5317\u7701").put((Object)"43", (Object)"\u6e56\u5357\u7701").put((Object)"44", (Object)"\u5e7f\u4e1c\u7701").put((Object)"45", (Object)"\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a").put((Object)"46", (Object)"\u6d77\u5357\u7701").put((Object)"50", (Object)"\u91cd\u5e86\u5e02").put((Object)"51", (Object)"\u56db\u5ddd\u7701").put((Object)"52", (Object)"\u8d35\u5dde\u7701").put((Object)"53", (Object)"\u4e91\u5357\u7701").put((Object)"54", (Object)"\u897f\u85cf\u81ea\u6cbb\u533a").put((Object)"61", (Object)"\u9655\u897f\u7701").put((Object)"62", (Object)"\u7518\u8083\u7701").put((Object)"63", (Object)"\u9752\u6d77\u7701").put((Object)"64", (Object)"\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a").put((Object)"65", (Object)"\u65b0\u7586\u7ef4\u543e\u5c14\u65cf\u81ea\u6cbb\u533a").put((Object)"71", (Object)"\u53f0\u6e7e").put((Object)"81", (Object)"\u9999\u6e2f").put((Object)"82", (Object)"\u6fb3\u95e8").put((Object)"91", (Object)"\u56fd\u5916");
        CITY_CODE = cityBuilder.build();
        ImmutableMap.Builder twFirstCodeBuilder = ImmutableMap.builder();
        twFirstCodeBuilder.put((Object)"A", (Object)10).put((Object)"B", (Object)11).put((Object)"C", (Object)12).put((Object)"D", (Object)13).put((Object)"E", (Object)14).put((Object)FEMALE, (Object)15).put((Object)"G", (Object)16).put((Object)"H", (Object)17).put((Object)"J", (Object)18).put((Object)"K", (Object)19).put((Object)"L", (Object)20).put((Object)MALE, (Object)21).put((Object)UN_KNOW, (Object)22).put((Object)"P", (Object)23).put((Object)"Q", (Object)24).put((Object)"R", (Object)25).put((Object)"S", (Object)26).put((Object)"T", (Object)27).put((Object)"U", (Object)28).put((Object)"V", (Object)29).put((Object)"X", (Object)30).put((Object)"Y", (Object)31).put((Object)"W", (Object)32).put((Object)"Z", (Object)33).put((Object)"I", (Object)34).put((Object)"O", (Object)35);
        TW_FIRST_CODE = twFirstCodeBuilder.build();
        ImmutableMap.Builder hkFirstCodeBuilder = ImmutableMap.builder();
        hkFirstCodeBuilder.put((Object)"A", (Object)1).put((Object)"B", (Object)2).put((Object)"C", (Object)3).put((Object)"R", (Object)18).put((Object)"U", (Object)21).put((Object)"Z", (Object)26).put((Object)"X", (Object)24).put((Object)"W", (Object)23).put((Object)"O", (Object)15).put((Object)UN_KNOW, (Object)14);
        HK_FIRST_CODE = hkFirstCodeBuilder.build();
    }
}

