/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.dto;

import app.myoss.cloud.core.lang.dto.Sort;
import app.myoss.cloud.core.lang.json.JsonApi;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApiModel(value="\u5c01\u88c5\u5206\u9875\u67e5\u8be2\u53c2\u6570")
public class Page<T>
implements Serializable {
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int DEFAULT_PAGE_NUM = 1;
    private static final long serialVersionUID = -3939417600928116634L;
    @ApiModelProperty(value="\u6bcf\u9875\u6761\u6570")
    private int pageSize = 20;
    @ApiModelProperty(value="\u7b2c\u51e0\u9875\uff0c\u5728MySQL\u4e2d\u662f\u4ece0\u5f00\u59cb\uff0c\u4f7f\u7528\u7684\u65f6\u5019\u9700\u8981\u51cf\u4e00")
    private int pageNum = 1;
    @ApiModelProperty(value="\u8bb0\u5f55\u603b\u6570")
    private int totalCount = 0;
    @ApiModelProperty(value="\u5206\u9875\u67e5\u8be2\u6761\u4ef6\u53c2\u6570", notes="\u6cdb\u578b")
    private T param;
    @ApiModelProperty(value="\u5206\u9875\u6392\u5e8f\u5b57\u6bb5")
    private Sort sort;
    @ApiModelProperty(value="\u7ed3\u679c\u5217\u8868\u6570\u636e", notes="\u6cdb\u578b")
    private List<T> value;
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f")
    private boolean success = true;
    @ApiModelProperty(value="\u6269\u5c55\u4fe1\u606f")
    private String errorMsg;
    @ApiModelProperty(value="\u9519\u8bef\u4ee3\u7801")
    private String errorCode;
    @ApiModelProperty(value="\u6269\u5c55\u4fe1\u606f")
    private Map<String, Object> extraInfo;

    public Page() {
    }

    public Page(T param) {
        this();
        this.param = param;
    }

    public Page(List<T> value) {
        this();
        this.value = value;
    }

    public Page(String errorCode, String errorMsg) {
        this(false, errorCode, errorMsg);
    }

    public Page(boolean success, String errorCode, String errorMsg) {
        this(success, null, errorCode, errorMsg);
    }

    public Page(boolean success, List<T> value, String errorCode, String errorMsg) {
        this();
        this.success = success;
        this.value = value;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public int getPageSize() {
        return this.pageSize < 1 ? 20 : this.pageSize;
    }

    public int getPageNum() {
        return this.pageNum < 1 ? 1 : this.pageNum;
    }

    public void addExtraInfo(String key, Object value) {
        if (this.extraInfo == null) {
            this.extraInfo = new HashMap<String, Object>();
        }
        this.extraInfo.put(key, value);
    }

    public Object getExtraInfo(String key) {
        return this.extraInfo != null ? this.extraInfo.get(key) : null;
    }

    public String toString() {
        return JsonApi.toJson(this);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public T getParam() {
        return this.param;
    }

    public Sort getSort() {
        return this.sort;
    }

    public List<T> getValue() {
        return this.value;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Map<String, Object> getExtraInfo() {
        return this.extraInfo;
    }

    public Page<T> setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Page<T> setPageNum(int pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    public Page<T> setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public Page<T> setParam(T param) {
        this.param = param;
        return this;
    }

    public Page<T> setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public Page<T> setValue(List<T> value) {
        this.value = value;
        return this;
    }

    public Page<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Page<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public Page<T> setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Page<T> setExtraInfo(Map<String, Object> extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        T this$param = this.getParam();
        T other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        Sort this$sort = this.getSort();
        Sort other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        List<T> this$value = this.getValue();
        List<T> other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        Map<String, Object> this$extraInfo = this.getExtraInfo();
        Map<String, Object> other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !((Object)this$extraInfo).equals(other$extraInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getTotalCount();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        T $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        Sort $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        List<T> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        Map<String, Object> $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : ((Object)$extraInfo).hashCode());
        return result;
    }
}

