/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.json;

import app.myoss.cloud.core.lang.base.JavaTypeUtils;
import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.core.lang.json.JsonArray;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class JsonObject
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -143079352260106094L;
    private final Map<String, Object> members;

    public JsonObject() {
        this(16, true);
    }

    public JsonObject(Map<String, Object> src) {
        this.members = Objects.requireNonNull(src);
    }

    public JsonObject(boolean ordered) {
        this(16, ordered);
    }

    public JsonObject(int initialCapacity) {
        this(initialCapacity, true);
    }

    public JsonObject(int initialCapacity, boolean ordered) {
        this.members = ordered ? new LinkedHashMap<String, Object>(initialCapacity) : new HashMap<String, Object>(initialCapacity);
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.members.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.members.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.members.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.members.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.members.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> src) {
        this.members.putAll(src);
    }

    @Override
    public void clear() {
        this.members.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.members.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.members.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.members.entrySet();
    }

    public String toString() {
        return this.toJson();
    }

    public Object clone() {
        return new JsonObject(this.members instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.members) : new HashMap<String, Object>(this.members));
    }

    @Override
    public boolean equals(Object obj) {
        return this.members.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.members.hashCode();
    }

    public String toJson() {
        return JsonApi.toJson(this.members);
    }

    public void toJson(Appendable writer) {
        JsonApi.toJson(this.members, writer);
    }

    public <T> List<T> getAsList(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toList(value);
    }

    public JsonArray getAsJsonArray(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toJsonArray(value);
    }

    public JsonObject getAsJsonObject(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toJsonObject(value);
    }

    Boolean getAsBooleanWrapper(String key) {
        Object value = this.get(key);
        return (Boolean)value;
    }

    public boolean getAsBoolean(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toBoolean(value);
    }

    public Number getAsNumber(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toNumber(value);
    }

    public String getAsString(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toString(value);
    }

    public Double getAsDouble(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toDouble(value);
    }

    public BigDecimal getAsBigDecimal(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toBigDecimal(value);
    }

    public BigInteger getAsBigInteger(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toBigInteger(value);
    }

    public Float getAsFloat(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toFloat(value);
    }

    public Long getAsLong(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toLong(value);
    }

    public Short getAsShort(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toShort(value);
    }

    public Integer getAsInt(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toInt(value);
    }

    public Byte getAsByte(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toByte(value);
    }

    public char getAsCharacter(String key) {
        Object value = this.get(key);
        return JavaTypeUtils.toCharacter(value);
    }
}

