/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.json.impl;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.json.JsonObject;
import app.myoss.cloud.core.lang.json.JsonSpi;
import app.myoss.cloud.core.utils.JacksonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;

public class JacksonApi
implements JsonSpi {
    private JacksonMapper jacksonMapper;

    @Override
    public <T> T getApi() {
        return (T)this.jacksonMapper;
    }

    @Override
    public <T> void setApi(T api) {
        this.jacksonMapper = (JacksonMapper)api;
    }

    @Override
    public String toJson(Object src) {
        return this.jacksonMapper.toJson(src);
    }

    @Override
    public String toJson(Object src, Type typeOfSrc) {
        ObjectMapper mapper = this.jacksonMapper.getMapper();
        JavaType javaType = mapper.constructType(typeOfSrc);
        try {
            return mapper.writerFor(javaType).writeValueAsString(src);
        }
        catch (JsonProcessingException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public void toJson(Object src, Appendable writer) {
        try {
            this.jacksonMapper.getMapper().writeValue((Writer)writer, src);
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public void toJson(Object src, Type typeOfSrc, Appendable writer) {
        ObjectMapper mapper = this.jacksonMapper.getMapper();
        JavaType javaType = mapper.constructType(typeOfSrc);
        try {
            mapper.writerFor(javaType).writeValue((Writer)writer, src);
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> classOfT) {
        return this.jacksonMapper.fromJson(json, classOfT);
    }

    @Override
    public <T> T fromJson(String json, Type typeOfT) {
        ObjectMapper mapper = this.jacksonMapper.getMapper();
        JavaType javaType = mapper.constructType(typeOfT);
        try {
            return (T)mapper.readerFor(javaType).readValue(json);
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(Reader json, Class<T> classOfT) {
        try {
            return (T)this.jacksonMapper.getMapper().readValue(json, classOfT);
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public <T> T fromJson(Reader json, Type typeOfT) {
        ObjectMapper mapper = this.jacksonMapper.getMapper();
        JavaType javaType = mapper.constructType(typeOfT);
        try {
            return (T)mapper.readerFor(javaType).readValue(json);
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public JsonObject fromJson(String json) {
        return this.jacksonMapper.fromJson(json, JsonObject.class);
    }

    @Override
    public JsonObject fromJson(Reader json) {
        try {
            return (JsonObject)this.jacksonMapper.getMapper().readValue(json, JacksonMapper.JSON_OBJECT_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    @Override
    public <T> List<T> fromJsonArray(String json, Class<T> clazz) {
        JavaType javaType = this.jacksonMapper.constructCollectionType(List.class, clazz);
        return (List)this.jacksonMapper.fromJson(json, javaType);
    }
}

