/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.base;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.base.ParsedNumber;
import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.core.lang.json.JsonArray;
import app.myoss.cloud.core.lang.json.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JavaTypeUtils {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};

    public static boolean isPrimitiveOrString(Object value) {
        if (value instanceof String) {
            return true;
        }
        Class<?> classOfPrimitive = value.getClass();
        for (Class<?> standardPrimitive : PRIMITIVE_TYPES) {
            if (!standardPrimitive.isAssignableFrom(classOfPrimitive)) continue;
            return true;
        }
        return false;
    }

    public static boolean isString(Object value) {
        return value instanceof String;
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static Boolean toBooleanWrapper(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigDecimal) {
            return JavaTypeUtils.toInt((BigDecimal)value) == 1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        String s = JavaTypeUtils.toString(value);
        if (s.length() == 0 || "null".equals(s) || "NULL".equals(s)) {
            return null;
        }
        if ("true".equalsIgnoreCase(s) || "1".equals(s)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(s) || "0".equals(s)) {
            return Boolean.FALSE;
        }
        if ("Y".equalsIgnoreCase(s) || "T".equals(s)) {
            return Boolean.TRUE;
        }
        if ("F".equalsIgnoreCase(s) || "N".equals(s)) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(s);
    }

    public static boolean toBoolean(Object value) {
        if (JavaTypeUtils.isBoolean(value)) {
            return (Boolean)value;
        }
        return JavaTypeUtils.toBooleanWrapper(value);
    }

    public static boolean isNumber(Object value) {
        return value instanceof Number;
    }

    public static Number toNumber(Object value) {
        return value instanceof String ? new ParsedNumber((String)value) : (Number)value;
    }

    public static Double toDouble(Object value) {
        return JavaTypeUtils.isNumber(value) ? ((Number)value).doubleValue() : Double.parseDouble(JavaTypeUtils.toString(value));
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
    }

    public static BigInteger toBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof BigInteger ? (BigInteger)value : new BigInteger(value.toString());
    }

    public static Float toFloat(Object value) {
        return Float.valueOf(JavaTypeUtils.isNumber(value) ? ((Number)value).floatValue() : Float.parseFloat(JavaTypeUtils.toString(value)));
    }

    public static Long toLong(Object value) {
        return JavaTypeUtils.isNumber(value) ? ((Number)value).longValue() : Long.parseLong(JavaTypeUtils.toString(value));
    }

    public static Short toShort(Object value) {
        return JavaTypeUtils.isNumber(value) ? ((Number)value).shortValue() : Short.parseShort(JavaTypeUtils.toString(value));
    }

    public static Integer toInt(Object value) {
        return JavaTypeUtils.isNumber(value) ? ((Number)value).intValue() : Integer.parseInt(JavaTypeUtils.toString(value));
    }

    public static Byte toByte(Object value) {
        return JavaTypeUtils.isNumber(value) ? ((Number)value).byteValue() : Byte.parseByte(JavaTypeUtils.toString(value));
    }

    public static byte[] toBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return Base64.getDecoder().decode((String)value);
        }
        throw new BizRuntimeException("can not convert to byte[], value : " + value);
    }

    public static char toCharacter(Object value) {
        return JavaTypeUtils.toString(Objects.requireNonNull(value)).charAt(0);
    }

    public static byte toByte(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.byteValue();
        }
        return decimal.byteValueExact();
    }

    public static short toShort(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.shortValue();
        }
        return decimal.shortValueExact();
    }

    public static int toInt(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.intValue();
        }
        return decimal.intValueExact();
    }

    public static long toLong(BigDecimal decimal) {
        if (decimal == null) {
            return 0L;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.longValue();
        }
        return decimal.longValueExact();
    }

    public static <T> List<T> toList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList((Collection)value);
        }
        return JsonApi.fromJson(value.toString(), List.class);
    }

    public static JsonArray toJsonArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonArray) {
            return (JsonArray)value;
        }
        if (value instanceof Collection) {
            return new JsonArray((Collection)value);
        }
        return JsonApi.fromJson(value.toString(), JsonArray.class);
    }

    public static JsonObject toJsonObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObject) {
            return (JsonObject)value;
        }
        if (value instanceof Map) {
            return new JsonObject((Map)value);
        }
        return JsonApi.fromJson(value.toString());
    }
}

