/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.dto;

import app.myoss.cloud.core.lang.dto.Direction;
import app.myoss.cloud.core.lang.dto.Order;
import app.myoss.cloud.core.lang.json.JsonApi;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.JsonAdapter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@JSONType(deserializer=ModelValueDeserializer.class)
@JsonAdapter(value=ModelValueJsonAdapter.class)
@JsonDeserialize(using=ModelValueJacksonDeserializer.class)
@JsonSerialize(using=ModelValueJacksonSerializer.class)
public class Sort
implements Iterable<Order>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(Sort.class);
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private static final long serialVersionUID = -6185297542401976741L;
    @JSONField(serialize=false, deserialize=false)
    @Expose(serialize=false, deserialize=false)
    @JsonIgnore
    private final List<Order> orders;

    public Sort(Order ... orders) {
        this(Arrays.asList(orders));
    }

    public Sort(List<Order> orders) {
        if (null == orders || orders.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one sort property to sort by!");
        }
        this.orders = orders;
    }

    public Sort(String ... properties) {
        this(DEFAULT_DIRECTION, properties);
    }

    public Sort(Direction direction, String ... properties) {
        this(direction, properties != null ? Arrays.asList(properties) : new ArrayList<String>());
    }

    public Sort(Direction direction, List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one property to sort by!");
        }
        this.orders = new ArrayList<Order>(properties.size());
        for (String property : properties) {
            this.orders.add(new Order(direction, property));
        }
    }

    public Sort and(Sort sort) {
        if (sort == null) {
            return this;
        }
        ArrayList<Order> these = new ArrayList<Order>(this.orders);
        for (Order order : sort) {
            these.add(order);
        }
        return new Sort(these);
    }

    public Order getOrderFor(String property) {
        for (Order order : this) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort that = (Sort)obj;
        return this.orders.equals(that.orders);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    public String toString() {
        return JsonApi.toJson(this.orders);
    }

    public static class ModelValueJacksonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<Sort> {
        public void serialize(Sort value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            List<Order> orders = value.getOrders();
            gen.writeStartArray();
            for (Order order : orders) {
                gen.writeStartObject();
                gen.writeStringField("direction", order.getDirection().name());
                gen.writeStringField("property", order.getProperty());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
    }

    public static class ModelValueJacksonDeserializer
    extends JsonDeserializer<Sort> {
        public Sort deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayNode node = (ArrayNode)jsonParser.getCodec().readTree(jsonParser);
            if (node == null || node.size() == 0) {
                return null;
            }
            ArrayList<Order> orders = new ArrayList<Order>(node.size());
            for (JsonNode json : node) {
                Order order = new Order(Direction.valueOf(json.get("direction").asText()), json.get("property").asText());
                orders.add(order);
            }
            return new Sort(orders);
        }
    }

    public static class ModelValueJsonAdapter
    implements com.google.gson.JsonDeserializer<Sort>,
    JsonSerializer<Sort> {
        public Sort deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray jsonArray = json.getAsJsonArray();
            if (jsonArray == null || jsonArray.size() == 0) {
                return null;
            }
            ArrayList<Order> orders = new ArrayList<Order>(jsonArray.size());
            for (JsonElement o : jsonArray) {
                JsonObject item = o.getAsJsonObject();
                String property = item.get("property").getAsString();
                String direction = item.get("direction").getAsString();
                Order order = new Order(Direction.fromStringOrNull(direction), property);
                orders.add(order);
            }
            return new Sort(orders);
        }

        public JsonElement serialize(Sort src, Type typeOfSrc, JsonSerializationContext context) {
            List<Order> orders = src.getOrders();
            return context.serialize(orders);
        }
    }

    public static class ModelValueDeserializer
    implements ObjectDeserializer {
        public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            JSONArray jsonArray = (JSONArray)parser.parse();
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                return null;
            }
            ArrayList<Order> orders = new ArrayList<Order>(jsonArray.size());
            for (Object o : jsonArray) {
                JSONObject item = (JSONObject)o;
                String property = (String)item.get((Object)"property");
                String direction = (String)item.get((Object)"direction");
                Order order = new Order(Direction.fromStringOrNull(direction), property);
                orders.add(order);
            }
            return (T)new Sort(orders);
        }

        public int getFastMatchToken() {
            return 0;
        }
    }
}

