/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.io;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.io.StreamUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.DefaultResourceLoader;

public class FileUtil {
    public static Path createDirectory(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                return Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BizRuntimeException("create directory failed [" + path + "]", e);
            }
        }
        return path;
    }

    public static Path createDirectories(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                return Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BizRuntimeException("create directories failed [" + path + "]", e);
            }
        }
        return path;
    }

    public static String toJarFilePath(String jarUrl) {
        jarUrl = jarUrl.startsWith("jar:") ? jarUrl : String.format("jar:%s", jarUrl);
        return jarUrl.indexOf("!/") > 0 ? jarUrl.substring(0, jarUrl.indexOf("!/") + 2) : jarUrl + "!/";
    }

    public static JarFile toJarFile(String jarUrl) {
        String jarPath = FileUtil.toJarFilePath(jarUrl);
        try {
            URL url = new URL(jarPath);
            JarURLConnection jar = (JarURLConnection)url.openConnection();
            return jar.getJarFile();
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    public static JarFile toJarFile(URL jarUrl) {
        try {
            JarURLConnection jar = (JarURLConnection)jarUrl.openConnection();
            return jar.getJarFile();
        }
        catch (IOException e) {
            throw new BizRuntimeException(e);
        }
    }

    public static Path toPath(URL url) {
        String protocol = url.getProtocol();
        try {
            if ("jar".equals(protocol)) {
                return Paths.get(new URI(url.getPath()));
            }
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new BizRuntimeException("url to path failed [" + url.toString() + "]", e);
        }
    }

    public static Map<String, InputStream> getFilesFromJar(URL jarPath, String directory, boolean excludeChildDirectory, boolean addEmptyDirectory) {
        Path path;
        JarFile jarFile = FileUtil.toJarFile(jarPath);
        Enumeration<JarEntry> entries = jarFile.entries();
        LinkedHashMap<String, InputStream> files = new LinkedHashMap<String, InputStream>();
        if (entries == null || !entries.hasMoreElements()) {
            return files;
        }
        LinkedHashMap emptyDirectory = null;
        if (addEmptyDirectory) {
            emptyDirectory = new LinkedHashMap();
        }
        if (!(path = FileUtil.toPath(jarPath)).endsWith(".jar!")) {
            path = path.resolveSibling("");
        }
        Path directoryPath = path.resolve(directory);
        while (entries.hasMoreElements()) {
            InputStream inputStream;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(directory) || excludeChildDirectory && !path.resolve(name).getParent().equals(directoryPath)) continue;
            if (entry.isDirectory()) {
                if (!addEmptyDirectory) continue;
                emptyDirectory.put(StringUtils.removeEnd((String)name, (String)"/"), null);
                continue;
            }
            try {
                inputStream = jarFile.getInputStream(entry);
            }
            catch (IOException e) {
                throw new BizRuntimeException(e);
            }
            files.put(name, inputStream);
        }
        if (addEmptyDirectory) {
            Iterator iterator = emptyDirectory.entrySet().iterator();
            block3: while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                for (String item : files.keySet()) {
                    if (!item.startsWith(key)) continue;
                    iterator.remove();
                    continue block3;
                }
            }
            files.putAll(emptyDirectory);
        }
        return files;
    }

    public static Map<String, InputStream> getFilesFromDirectory(Path rootDirectory, Path directory, boolean excludeChildDirectory, boolean addEmptyDirectory) {
        try {
            LinkedHashMap<String, InputStream> files = new LinkedHashMap<String, InputStream>();
            Files.list(directory).forEach(path -> {
                if (excludeChildDirectory && !path.getParent().equals(rootDirectory)) {
                    return;
                }
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Map<String, InputStream> childFiles = FileUtil.getFilesFromDirectory(rootDirectory, path, excludeChildDirectory, addEmptyDirectory);
                    if (childFiles.isEmpty()) {
                        if (addEmptyDirectory) {
                            files.put(path.toString(), null);
                        }
                    } else {
                        files.putAll(childFiles);
                    }
                } else {
                    try {
                        FileInputStream inputStream = new FileInputStream(path.toFile());
                        files.put(path.toString(), inputStream);
                    }
                    catch (FileNotFoundException e) {
                        throw new BizRuntimeException("path: " + path, e);
                    }
                }
            });
            return files;
        }
        catch (IOException e) {
            throw new BizRuntimeException("directory: " + directory, e);
        }
    }

    public static Map<String, InputStream> getFilesFromDirectory(Path directory, boolean excludeChildDirectory, boolean addEmptyDirectory) {
        return FileUtil.getFilesFromDirectory(directory, directory, excludeChildDirectory, addEmptyDirectory);
    }

    public static Map<String, InputStream> getFilesFromDirectory(Path directory) {
        return FileUtil.getFilesFromDirectory(directory, false, false);
    }

    public static Map<String, InputStream> getFilesFromDirectory(String directory, boolean excludeChildDirectory, boolean addEmptyDirectory) {
        Path rootDirectory = Paths.get(directory, new String[0]);
        return FileUtil.getFilesFromDirectory(rootDirectory, rootDirectory, excludeChildDirectory, addEmptyDirectory);
    }

    public static Map<String, InputStream> getFilesFromDirectory(String directory) {
        return FileUtil.getFilesFromDirectory(directory, false, false);
    }

    public static InputStream getResource(String location) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        try {
            return resourceLoader.getResource(location).getInputStream();
        }
        catch (IOException e) {
            throw new BizRuntimeException("get resource failed: " + location, e);
        }
    }

    public static String readFileContent(String location) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        try {
            InputStream inputStream = resourceLoader.getResource(location).getInputStream();
            return StreamUtil.copyToString(inputStream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new BizRuntimeException("get resource failed: " + location, e);
        }
    }

    private FileUtil() {
    }
}

