/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.lang.json;

import app.myoss.cloud.core.lang.json.JsonArray;
import app.myoss.cloud.core.lang.json.JsonObject;
import app.myoss.cloud.core.lang.json.JsonSpi;
import app.myoss.cloud.core.lang.json.impl.FastJsonApi;
import app.myoss.cloud.core.lang.json.impl.GsonApi;
import app.myoss.cloud.core.lang.json.impl.JacksonApi;
import app.myoss.cloud.core.utils.JacksonMapper;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.util.ClassUtils;

public final class JsonApi {
    public static final boolean JACKSON_2_PRESENT;
    public static final boolean GSON_PRESENT;
    public static final boolean FASTJSON_PRESENT;
    private static final JsonSpi JSON_SPI;

    public static void checkJsonDependency() {
        if (GSON_PRESENT || FASTJSON_PRESENT || JACKSON_2_PRESENT) {
            return;
        }
        throw new UnsupportedOperationException("please add json dependency: gson or fastjson or jackson ");
    }

    public static JsonSpi getJsonSpi() {
        if (JSON_SPI != null) {
            return JSON_SPI;
        }
        ServiceLoader<JsonSpi> serializers = ServiceLoader.load(JsonSpi.class);
        List apis = StreamSupport.stream(serializers.spliterator(), false).collect(Collectors.toList());
        Iterator iterator = apis.iterator();
        if (iterator.hasNext()) {
            JsonSpi api = (JsonSpi)iterator.next();
            if (api instanceof JacksonApi && JACKSON_2_PRESENT) {
                JsonApi.checkJsonDependency();
                JacksonApi jacksonApi = (JacksonApi)api;
                jacksonApi.setApi(JacksonMapper.nonNullMapper());
                return api;
            }
            if (api instanceof GsonApi && GSON_PRESENT) {
                JsonApi.checkJsonDependency();
                GsonApi gsonApi = (GsonApi)api;
                gsonApi.setApi(new GsonBuilder().disableHtmlEscaping().create());
                return api;
            }
            if (api instanceof FastJsonApi && FASTJSON_PRESENT) {
                JsonApi.checkJsonDependency();
                return api;
            }
            return api;
        }
        throw new UnsupportedOperationException("please add JsonApi in the file: META-INF/services/app.myoss.cloud.core.lang.json.JsonApi");
    }

    public static String toJson(Object src) {
        return JSON_SPI.toJson(src);
    }

    public static String toJson(Object src, Type typeOfSrc) {
        return JSON_SPI.toJson(src, typeOfSrc);
    }

    public static void toJson(Object src, Appendable writer) {
        JSON_SPI.toJson(src, writer);
    }

    public static void toJson(Object src, Type typeOfSrc, Appendable writer) {
        JSON_SPI.toJson(src, typeOfSrc, writer);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return JSON_SPI.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return JSON_SPI.fromJson(json, typeOfT);
    }

    public static <T> T fromJson(Reader json, Class<T> classOfT) {
        return JSON_SPI.fromJson(json, classOfT);
    }

    public <T> T fromJson(Reader json, Type typeOfT) {
        return JSON_SPI.fromJson(json, typeOfT);
    }

    public static JsonObject fromJson(String json) {
        return JSON_SPI.fromJson(json);
    }

    public static JsonObject fromJson(Reader json) {
        return JSON_SPI.fromJson(json);
    }

    public static JsonArray fromJsonArray(String json) {
        return JSON_SPI.fromJson(json, JsonArray.class);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> clazz) {
        return JSON_SPI.fromJsonArray(json, clazz);
    }

    static {
        ClassLoader classLoader = JsonApi.class.getClassLoader();
        JACKSON_2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        GSON_PRESENT = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
        FASTJSON_PRESENT = ClassUtils.isPresent((String)"com.alibaba.fastjson.JSON", (ClassLoader)classLoader);
        JSON_SPI = JsonApi.getJsonSpi();
    }
}

