/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.core.spring.boot.config;

import app.myoss.cloud.core.constants.DeployEnvEnum;
import app.myoss.cloud.core.utils.YamlUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CoreCommonEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered,
SmartApplicationListener {
    private static final DeferredLog LOGGER = new DeferredLog();
    public static final int DEFAULT_ORDER = -2147483629;
    public static final String PROPERTY_SOURCE_NAME = "defaultProperties";
    private int order = -2147483629;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ClassPathResource path = new ClassPathResource("core-config/application.yml");
        LinkedHashMap<String, Object> linkedHashMap = YamlUtils.loadYaml2Map((Resource)path);
        CoreCommonEnvironmentPostProcessor.addOrReplace(environment.getPropertySources(), linkedHashMap);
        String deployEnv = DeployEnvEnum.getDeployEnv();
        if (deployEnv == null) {
            deployEnv = environment.getProperty("DEPLOY_ENV");
        }
        path = new ClassPathResource("core-config/application-" + deployEnv + ".yml");
        linkedHashMap = YamlUtils.loadYaml2Map((Resource)path);
        CoreCommonEnvironmentPostProcessor.addOrReplace(environment.getPropertySources(), linkedHashMap);
    }

    public static void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        if (map == null) {
            return;
        }
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            ((Map)target.getSource()).putAll(map);
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationPreparedEvent) {
            LOGGER.replayTo(CoreCommonEnvironmentPostProcessor.class);
        }
    }

    public int getOrder() {
        return this.order;
    }
}

