/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.web.servlet.filter;

import brave.internal.HexCodec;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

public class LogWebRequestFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"WebRequest");
    public static final String MDC_START_TIME = "startTime";
    public static final String MDC_COST_TIME = "costTime";
    public static final String MDC_STATUS = "status";
    public static final String MDC_METHOD = "method";
    public static final String MDC_REQUEST_SERVER_INFO = "requestServerInfo";
    public static final String MDC_REQUEST_URL = "requestURL";
    public static final String MDC_REQUEST_URL_WITH_QUERY_STRING = "requestURLWithQueryString";
    public static final String MDC_REQUEST_URI = "requestURI";
    public static final String MDC_REQUEST_URI_WITH_QUERY_STRING = "requestURIWithQueryString";
    public static final String MDC_QUERY_STRING = "queryString";
    public static final String MDC_REMOTE_ADDR = "remoteAddr";
    public static final String MDC_REMOTE_HOST = "remoteHost";
    public static final String MDC_USER_AGENT = "userAgent";
    public static final String MDC_REFERRER = "referrer";
    public static final String MDC_COOKIES = "cookies";
    public static final String MDC_COOKIE_PREFIX = "cookie.";
    private boolean logOnFilter = false;
    private boolean putRequestInfoToMDC = false;
    private String traceIdName;
    private String spanIdName;

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC) {
        this(logOnFilter, putRequestInfoToMDC, null, null);
    }

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC, String traceIdName, String spanIdName) {
        this.logOnFilter = logOnFilter;
        this.putRequestInfoToMDC = putRequestInfoToMDC;
        this.traceIdName = StringUtils.isNotBlank((CharSequence)traceIdName) ? traceIdName : "X-B3-TraceId";
        this.spanIdName = StringUtils.isNotBlank((CharSequence)spanIdName) ? spanIdName : "X-B3-SpanId";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        long startNs = System.nanoTime();
        Date date = new Date();
        String time = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try {
            this.putMDC(request, time);
            Object traceContext = request.getAttribute(TraceContext.class.getName());
            if (traceContext != null) {
                TraceContext context = (TraceContext)traceContext;
                String traceId = context.traceIdString();
                String spanId = HexCodec.toLowerHex((long)context.spanId());
                response.addHeader(this.traceIdName, traceId);
                response.addHeader(this.spanIdName, spanId);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Map<String, String> mdc = this.getMDCCopy();
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            this.putMDC(mdc, MDC_COST_TIME, String.valueOf(tookMs));
            this.putMDC(mdc, MDC_STATUS, String.valueOf(response.getStatus()));
            MDC.setContextMap(mdc);
            if (this.logOnFilter) {
                log.info("");
            }
            this.clearMDC();
        }
    }

    protected void putMDC(HttpServletRequest request, String startTime) {
        Map<String, String> mdc = this.getMDCCopy();
        this.putMDC(mdc, MDC_START_TIME, startTime);
        if (!this.putRequestInfoToMDC) {
            MDC.setContextMap(mdc);
            return;
        }
        this.putMDC(mdc, MDC_METHOD, request.getMethod());
        this.putMDC(mdc, MDC_REQUEST_SERVER_INFO, request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort());
        StringBuilder requestURL = new StringBuilder(request.getRequestURL());
        String queryString = StringUtils.trimToNull((String)request.getQueryString());
        this.putMDC(mdc, MDC_REQUEST_URL, this.getRequestURL(requestURL, null));
        this.putMDC(mdc, MDC_REQUEST_URL_WITH_QUERY_STRING, this.getRequestURL(requestURL, queryString));
        String requestURI = request.getRequestURI();
        String requestURIWithQueryString = queryString != null ? requestURI + "?" + queryString : requestURI;
        this.putMDC(mdc, MDC_REQUEST_URI, requestURI);
        this.putMDC(mdc, MDC_REQUEST_URI_WITH_QUERY_STRING, requestURIWithQueryString);
        this.putMDC(mdc, MDC_QUERY_STRING, queryString);
        this.putMDC(mdc, MDC_REMOTE_HOST, request.getRemoteHost());
        this.putMDC(mdc, MDC_REMOTE_ADDR, request.getRemoteAddr());
        this.putMDC(mdc, MDC_USER_AGENT, request.getHeader("User-Agent"));
        this.putMDC(mdc, MDC_REFERRER, request.getHeader("Referer"));
        Cookie[] cookies = request.getCookies();
        List names = Collections.emptyList();
        if (cookies != null) {
            names = new ArrayList(cookies.length);
            for (Cookie cookie : cookies) {
                names.add(cookie.getName());
                this.putMDC(mdc, MDC_COOKIE_PREFIX + cookie.getName(), cookie.getValue());
            }
            Collections.sort(names);
        }
        this.putMDC(mdc, MDC_COOKIES, names.toString());
        MDC.setContextMap(mdc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestURL(StringBuilder requestURL, String queryString) {
        int length = requestURL.length();
        try {
            if (queryString != null) {
                requestURL.append('?').append(queryString);
            }
            String string = requestURL.toString();
            return string;
        }
        finally {
            requestURL.setLength(length);
        }
    }

    private void putMDC(Map<String, String> mdc, String key, String value) {
        if (value != null) {
            mdc.put(key, value);
        }
    }

    protected Map<String, String> getMDCCopy() {
        HashMap mdc = MDC.getCopyOfContextMap();
        if (mdc == null) {
            mdc = new HashMap();
        }
        return mdc;
    }

    public void clearMDC() {
        MDC.remove((String)MDC_START_TIME);
        MDC.remove((String)MDC_COST_TIME);
        MDC.remove((String)MDC_STATUS);
        if (this.putRequestInfoToMDC) {
            MDC.remove((String)MDC_METHOD);
            MDC.remove((String)MDC_REQUEST_URL);
            MDC.remove((String)MDC_REQUEST_URL_WITH_QUERY_STRING);
            MDC.remove((String)MDC_REQUEST_URI);
            MDC.remove((String)MDC_REQUEST_URI_WITH_QUERY_STRING);
            MDC.remove((String)MDC_QUERY_STRING);
            MDC.remove((String)MDC_REMOTE_ADDR);
            MDC.remove((String)MDC_REMOTE_HOST);
            MDC.remove((String)MDC_USER_AGENT);
            MDC.remove((String)MDC_REFERRER);
            MDC.remove((String)MDC_COOKIES);
            MDC.remove((String)MDC_COOKIE_PREFIX);
        }
    }
}

