/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.boot.config.http;

import app.myoss.cloud.core.constants.MyossConstants;
import app.myoss.cloud.web.spring.boot.config.FastJsonWebConfig;
import app.myoss.cloud.web.spring.boot.config.http.OkHttp3ConnectionPoolProperties;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={ConnectionPool.class, RestTemplate.class})
@EnableConfigurationProperties(value={OkHttp3ConnectionPoolProperties.class})
@ConditionalOnProperty(prefix="myoss-cloud.ok-http3.connection-pool", value={"enabled"}, matchIfMissing=false)
@ConditionalOnWebApplication
@Configuration
public class RestTemplate4OkHttp3ClientAutoConfiguration {
    private final OkHttp3ConnectionPoolProperties properties;

    public RestTemplate4OkHttp3ClientAutoConfiguration(OkHttp3ConnectionPoolProperties properties) {
        this.properties = properties;
    }

    @ConditionalOnMissingBean(name={"restTemplate4OkHttp3ConnectionPool"})
    @Bean(name={"restTemplate4OkHttp3ConnectionPool"})
    public ConnectionPool restTemplate4OkHttp3ConnectionPool() {
        return new ConnectionPool(this.properties.getMaxIdleConnections(), this.properties.getKeepAliveDuration(), TimeUnit.MINUTES);
    }

    @ConditionalOnMissingBean(name={"restTemplate4OkHttp3Interceptor"})
    @Bean(name={"restTemplate4OkHttp3Interceptor"})
    public List<Interceptor> restTemplate4OkHttp3Interceptor() {
        return Collections.emptyList();
    }

    @ConditionalOnMissingBean(name={"restTemplate4OkHttp3NetworkInterceptor"})
    @Bean(name={"restTemplate4OkHttp3NetworkInterceptor"})
    public List<Interceptor> restTemplate4OkHttp3NetworkInterceptor() {
        return Collections.emptyList();
    }

    @ConditionalOnMissingBean(name={"restTemplate4OkHttp3"})
    @Bean(name={"restTemplate4OkHttp3"})
    public RestTemplate restTemplate4OkHttp3(FastJsonConfig defaultFastJsonConfig, ConnectionPool restTemplate4OkHttp3ConnectionPool, List<Interceptor> restTemplate4OkHttp3Interceptor, List<Interceptor> restTemplate4OkHttp3NetworkInterceptor) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        if (!CollectionUtils.isEmpty(restTemplate4OkHttp3Interceptor)) {
            for (Interceptor item : restTemplate4OkHttp3Interceptor) {
                builder.addInterceptor(item);
            }
        }
        if (!CollectionUtils.isEmpty(restTemplate4OkHttp3NetworkInterceptor)) {
            for (Interceptor item : restTemplate4OkHttp3NetworkInterceptor) {
                builder.addNetworkInterceptor(item);
            }
        }
        OkHttpClient httpClient = builder.connectTimeout((long)this.properties.getConnectTimeout().intValue(), TimeUnit.MILLISECONDS).readTimeout((long)this.properties.getReadTimeout().intValue(), TimeUnit.MILLISECONDS).writeTimeout((long)this.properties.getWriteTimeout().intValue(), TimeUnit.MILLISECONDS).connectionPool(restTemplate4OkHttp3ConnectionPool).build();
        OkHttp3ClientHttpRequestFactory clientHttpRequestFactory = new OkHttp3ClientHttpRequestFactory(httpClient);
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(MyossConstants.DEFAULT_CHARSET);
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = FastJsonWebConfig.fastJsonHttpMessageConverter(defaultFastJsonConfig);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        List messageConverters = restTemplate.getMessageConverters();
        messageConverters.add(1, stringHttpMessageConverter);
        messageConverters.add(3, fastJsonHttpMessageConverter);
        return restTemplate;
    }
}

