/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.web.method.aspectj;

import app.myoss.cloud.apm.log.method.aspectj.MonitorMethodProperties;
import app.myoss.cloud.apm.spring.cloud.sleuth.trace.ApplicationEventTracer;
import app.myoss.cloud.core.constants.MyossConstants;
import app.myoss.cloud.web.spring.web.servlet.support.EmptyBodyCheckingHttpInputMessage;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ConditionalOnWebApplication
@ControllerAdvice
public class AopLogControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(AopLogControllerExceptionHandler.class);
    @Autowired
    protected MonitorMethodProperties properties;

    public static HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    public ResponseEntity<Object> handleException(Throwable ex, HttpServletRequest request) {
        HttpStatus status = AopLogControllerExceptionHandler.getStatus(request);
        return this.outputException(ex, new HttpHeaders(), status, request);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object responseBody, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            request.setAttribute("javax.servlet.error.exception", (Object)ex, 0);
        }
        HttpServletRequest servletRequest = ((ServletWebRequest)request).getRequest();
        return this.outputException(ex, headers, status, servletRequest);
    }

    protected ResponseEntity<Object> outputException(Throwable ex, HttpHeaders headers, HttpStatus status, HttpServletRequest servletRequest) {
        ServletServerHttpRequest serverHttpRequest = new ServletServerHttpRequest(servletRequest);
        URI requestURI = serverHttpRequest.getURI();
        String requestBody = null;
        try {
            EmptyBodyCheckingHttpInputMessage inputMessage = new EmptyBodyCheckingHttpInputMessage((HttpInputMessage)serverHttpRequest);
            if (inputMessage.hasBody()) {
                requestBody = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)MyossConstants.DEFAULT_CHARSET);
            } else if (!CollectionUtils.isEmpty((Map)servletRequest.getParameterMap())) {
                requestBody = JSON.toJSONString((Object)servletRequest.getParameterMap());
            }
        }
        catch (IOException e) {
            log.error("Could not read document", (Throwable)e);
        }
        HttpMethod method = serverHttpRequest.getMethod();
        String contentType = servletRequest.getContentType();
        if (ex instanceof RestClientResponseException) {
            RestClientResponseException exception = (RestClientResponseException)ex;
            String responseBody = exception.getResponseBodyAsString();
            log.error("requestUrl: {}, requestMethod: {}, requestBody: {}, contentType: {}\norg.springframework.web.client.RestClientResponseException: {}, responseBody: {} ", new Object[]{requestURI, method, requestBody, contentType, exception.getMessage(), responseBody, ex});
        } else {
            log.error("requestUrl: {}, requestMethod: {}, requestBody: {}, contentType: {}", new Object[]{requestURI, method, requestBody, contentType, ex});
        }
        String traceId = ApplicationEventTracer.getTraceId();
        String errorCode = this.properties.getControllerExceptionErrorCode();
        String errorMsg = this.properties.getControllerExceptionErrorMsg();
        String body = "{\"success\":false,\"errorCode\":\"" + errorCode + "\",\"errorMsg\":\"" + errorMsg + "\",\"value\":{\"traceId\":\"" + traceId + "\"}}";
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).body((Object)body);
    }
}

