/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.http;

import app.myoss.cloud.core.constants.MyossConstants;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okio.Buffer;
import org.springframework.util.LinkedMultiValueMap;

public class HttpUrlBuilder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    private List<String> encodedQueryNamesAndValues;

    public HttpUrlBuilder encodedQuery(String encodedQuery) {
        this.encodedQueryNamesAndValues = encodedQuery != null ? HttpUrlBuilder.queryStringToNamesAndValues(HttpUrlBuilder.canonicalize(encodedQuery, QUERY_ENCODE_SET, true, false, true, true)) : null;
        return this;
    }

    public String encodedQuery() {
        if (this.encodedQueryNamesAndValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        HttpUrlBuilder.namesAndValuesToQueryString(result, this.encodedQueryNamesAndValues);
        return result.toString();
    }

    public String query() {
        if (this.encodedQueryNamesAndValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        List<String> queryParameterNameAndValues = this.percentDecode(this.encodedQueryNamesAndValues, true);
        HttpUrlBuilder.namesAndValuesToQueryString(result, queryParameterNameAndValues);
        return result.toString();
    }

    public LinkedMultiValueMap<String, String> getQueryNamesAndValues() {
        return this.encodedQueryNamesAndValues != null ? this.percentDecode2(this.encodedQueryNamesAndValues, true) : null;
    }

    public boolean containsQueryParameter(String name) {
        String encodedName = HttpUrlBuilder.canonicalize(name, QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
        return this.containsQueryParameters(encodedName);
    }

    public HttpUrlBuilder removeQueryParameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            return this;
        }
        String encodedName = HttpUrlBuilder.canonicalize(name, QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
        String encodedValue = value != null ? HttpUrlBuilder.canonicalize(value, QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null;
        this.removeAllCanonicalQueryParameters(encodedName, encodedValue);
        return this;
    }

    public HttpUrlBuilder addQueryParameter(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            this.encodedQueryNamesAndValues = new ArrayList<String>();
        }
        this.encodedQueryNamesAndValues.add(HttpUrlBuilder.canonicalize(name, QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
        this.encodedQueryNamesAndValues.add(value != null ? HttpUrlBuilder.canonicalize(value, QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null);
        return this;
    }

    public HttpUrlBuilder addEncodedQueryParameter(String encodedName, String encodedValue) {
        if (encodedName == null) {
            throw new NullPointerException("encodedName == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            this.encodedQueryNamesAndValues = new ArrayList<String>();
        }
        this.encodedQueryNamesAndValues.add(HttpUrlBuilder.canonicalize(encodedName, QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
        this.encodedQueryNamesAndValues.add(encodedValue != null ? HttpUrlBuilder.canonicalize(encodedValue, QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null);
        return this;
    }

    public HttpUrlBuilder setQueryParameter(String name, String value) {
        this.removeAllQueryParameters(name);
        this.addQueryParameter(name, value);
        return this;
    }

    public HttpUrlBuilder setEncodedQueryParameter(String encodedName, String encodedValue) {
        this.removeAllEncodedQueryParameters(encodedName);
        this.addEncodedQueryParameter(encodedName, encodedValue);
        return this;
    }

    public HttpUrlBuilder removeAllQueryParameters(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            return this;
        }
        String nameToRemove = HttpUrlBuilder.canonicalize(name, QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
        this.removeAllCanonicalQueryParameters(nameToRemove);
        return this;
    }

    public HttpUrlBuilder removeAllEncodedQueryParameters(String encodedName) {
        if (encodedName == null) {
            throw new NullPointerException("encodedName == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            return this;
        }
        this.removeAllCanonicalQueryParameters(HttpUrlBuilder.canonicalize(encodedName, QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
        return this;
    }

    private void removeAllCanonicalQueryParameters(String canonicalName) {
        for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
            if (!canonicalName.equals(this.encodedQueryNamesAndValues.get(i))) continue;
            this.encodedQueryNamesAndValues.remove(i + 1);
            this.encodedQueryNamesAndValues.remove(i);
            if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
            this.encodedQueryNamesAndValues = null;
            return;
        }
    }

    private void removeAllCanonicalQueryParameters(String canonicalName, String canonicalValue) {
        for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
            if (!canonicalName.equals(this.encodedQueryNamesAndValues.get(i)) || !canonicalValue.equals(this.encodedQueryNamesAndValues.get(i + 1))) continue;
            this.encodedQueryNamesAndValues.remove(i + 1);
            this.encodedQueryNamesAndValues.remove(i);
            if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
            this.encodedQueryNamesAndValues = null;
            return;
        }
    }

    private boolean containsQueryParameters(String canonicalName) {
        for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
            if (!canonicalName.equals(this.encodedQueryNamesAndValues.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> percentDecode(List<String> list, boolean plusIsSpace) {
        int size = list.size();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String s = list.get(i);
            result.add(s != null ? HttpUrlBuilder.percentDecode(s, plusIsSpace) : null);
        }
        return Collections.unmodifiableList(result);
    }

    private LinkedMultiValueMap<String, String> percentDecode2(List<String> list, boolean plusIsSpace) {
        int size = list.size();
        LinkedMultiValueMap result = new LinkedMultiValueMap(size / 2 + 1);
        for (int i = 0; i < size; ++i) {
            String key = list.get(i++);
            String value = list.get(i);
            result.add((Object)key, value != null ? HttpUrlBuilder.percentDecode(value, plusIsSpace) : null);
        }
        return result;
    }

    static String percentDecode(String encoded, boolean plusIsSpace) {
        return HttpUrlBuilder.percentDecode(encoded, 0, encoded.length(), plusIsSpace);
    }

    static String percentDecode(String encoded, int pos, int limit, boolean plusIsSpace) {
        for (int i = pos; i < limit; ++i) {
            char c = encoded.charAt(i);
            if (c != '%' && (c != '+' || !plusIsSpace)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(encoded, pos, i);
            HttpUrlBuilder.percentDecode(out, encoded, i, limit, plusIsSpace);
            return out.readUtf8();
        }
        return encoded.substring(pos, limit);
    }

    static void percentDecode(Buffer out, String encoded, int pos, int limit, boolean plusIsSpace) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = encoded.codePointAt(i);
            if (codePoint == 37 && i + 2 < limit) {
                int d1 = HttpUrlBuilder.decodeHexDigit(encoded.charAt(i + 1));
                int d2 = HttpUrlBuilder.decodeHexDigit(encoded.charAt(i + 2));
                if (d1 != -1 && d2 != -1) {
                    out.writeByte((d1 << 4) + d2);
                    i += 2;
                    continue;
                }
            } else if (codePoint == 43 && plusIsSpace) {
                out.writeByte(32);
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static boolean percentEncoded(String encoded, int pos, int limit) {
        return pos + 2 < limit && encoded.charAt(pos) == '%' && HttpUrlBuilder.decodeHexDigit(encoded.charAt(pos + 1)) != -1 && HttpUrlBuilder.decodeHexDigit(encoded.charAt(pos + 2)) != -1;
    }

    static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    static void namesAndValuesToQueryString(StringBuilder out, List<String> namesAndValues) {
        int size = namesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            String name = namesAndValues.get(i);
            String value = namesAndValues.get(i + 1);
            if (i > 0) {
                out.append('&');
            }
            out.append(name);
            if (value == null) continue;
            out.append('=');
            out.append(value);
        }
    }

    static List<String> queryStringToNamesAndValues(String encodedQuery) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (pos <= encodedQuery.length()) {
            int equalsOffset;
            int ampersandOffset = encodedQuery.indexOf(38, pos);
            if (ampersandOffset == -1) {
                ampersandOffset = encodedQuery.length();
            }
            if ((equalsOffset = encodedQuery.indexOf(61, pos)) == -1 || equalsOffset > ampersandOffset) {
                result.add(encodedQuery.substring(pos, ampersandOffset));
                result.add(null);
            } else {
                result.add(encodedQuery.substring(pos, equalsOffset));
                result.add(encodedQuery.substring(equalsOffset + 1, ampersandOffset));
            }
            pos = ampersandOffset + 1;
        }
        return result;
    }

    static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (!(codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && (!alreadyEncoded || strict && !HttpUrlBuilder.percentEncoded(input, i, limit))) && (codePoint != 43 || !plusIsSpace)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, pos, i);
            HttpUrlBuilder.canonicalize(out, input, i, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
            return out.readUtf8();
        }
        return input.substring(pos, limit);
    }

    static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        int codePoint;
        Buffer encodedCharBuffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (codePoint == 43 && plusIsSpace) {
                out.writeUtf8(alreadyEncoded ? "+" : "%2B");
                continue;
            }
            if (codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && (!alreadyEncoded || strict && !HttpUrlBuilder.percentEncoded(input, i, limit))) {
                if (encodedCharBuffer == null) {
                    encodedCharBuffer = new Buffer();
                }
                if (charset == null || charset.equals(MyossConstants.UTF_8)) {
                    encodedCharBuffer.writeUtf8CodePoint(codePoint);
                } else {
                    encodedCharBuffer.writeString(input, i, i + Character.charCount(codePoint), charset);
                }
                while (!encodedCharBuffer.exhausted()) {
                    int b = encodedCharBuffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                    out.writeByte((int)HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly) {
        return HttpUrlBuilder.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, null);
    }
}

