/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.web.servlet.support;

import app.myoss.cloud.core.constants.MyossConstants;
import app.myoss.cloud.web.spring.web.servlet.support.ByteArrayServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class ReaderBodyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Lock lock = new ReentrantLock();
    private boolean marked = false;
    private ServletInputStream inputStream;

    public ReaderBodyHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public BufferedReader getReader() throws IOException {
        String characterEncoding = this.getCharacterEncoding();
        Charset charset = characterEncoding != null ? Charset.forName(characterEncoding) : MyossConstants.DEFAULT_CHARSET;
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.getInputStream(), charset);
        return new BufferedReader(inputStreamReader);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.marked) {
            this.warpInputStream();
        } else {
            this.inputStream.reset();
        }
        return this.inputStream;
    }

    private void warpInputStream() throws IOException {
        this.lock.lock();
        try {
            if (!this.marked) {
                ServletInputStream inputStreamSrc = this.getRequest().getInputStream();
                byte[] body = StreamUtils.copyToByteArray((InputStream)inputStreamSrc);
                this.inputStream = new ByteArrayServletInputStream(body);
            }
            this.marked = true;
        }
        finally {
            this.lock.unlock();
        }
    }
}

