/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.utils;

import app.myoss.cloud.web.utils.RestRequestCallback;
import app.myoss.cloud.web.utils.RestUtils;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private static RestTemplate REST_TEMPLATE;

    @EventListener
    public static void setCoreCommonProperties(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map restTemplateMap = applicationContext.getBeansOfType(RestTemplate.class);
        REST_TEMPLATE = restTemplateMap.containsKey("restTemplate4OkHttp3") ? (RestTemplate)restTemplateMap.get("restTemplate4OkHttp3") : (RestTemplate)restTemplateMap.entrySet().iterator().next().getValue();
    }

    public static RestTemplate getRestTemplate() {
        return REST_TEMPLATE;
    }

    public static <T> T exchange(HttpHeaders httpHeaders, MediaType contentType, URI uri, HttpMethod method, Object requestBody, Class<T> responseType, RestRequestCallback restRequestCallback) {
        return RestUtils.exchange(REST_TEMPLATE, httpHeaders, contentType, uri, method, requestBody, responseType, restRequestCallback);
    }

    public static <T> T exchange(HttpHeaders httpHeaders, MediaType contentType, URI uri, HttpMethod method, Object requestBody, Class<T> responseType) {
        return RestUtils.exchange(REST_TEMPLATE, httpHeaders, contentType, uri, method, requestBody, responseType);
    }

    public static <T> T exchange(MediaType contentType, URI uri, HttpMethod method, Object requestBody, Class<T> responseType) {
        return RestUtils.exchange(REST_TEMPLATE, contentType, uri, method, requestBody, responseType);
    }

    public static <T> T exchange(MediaType contentType, String url, HttpMethod method, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        return RestUtils.exchange(REST_TEMPLATE, contentType, url, method, requestBody, responseType, uriVariables);
    }

    public static String postJson(String url, String requestBody, Object ... uriVariables) {
        return RestUtils.postJson(REST_TEMPLATE, url, requestBody, uriVariables);
    }

    public static String postForm(String url, LinkedMultiValueMap<String, String> requestBody, Object ... uriVariables) {
        return RestUtils.postForm(REST_TEMPLATE, url, requestBody, uriVariables);
    }

    public static <T> T getForObject(String url, Map<String, String> parameterMap, Class<T> responseType, Object ... uriVariables) {
        return RestUtils.getForObject(REST_TEMPLATE, url, parameterMap, responseType, uriVariables);
    }

    public static String getForString(String url, Map<String, String> parameterMap, Object ... uriVariables) {
        return RestUtils.getForString(REST_TEMPLATE, url, parameterMap, uriVariables);
    }

    public static String getForString(String url, Object ... uriVariables) {
        return RestUtils.getForString(REST_TEMPLATE, url, uriVariables);
    }

    public static <T> T getForObject(String url, LinkedMultiValueMap<String, String> parameterMap, Class<T> responseType, Object ... uriVariables) {
        return RestUtils.getForObject(REST_TEMPLATE, url, parameterMap, responseType, uriVariables);
    }

    public static String getForString(String url, LinkedMultiValueMap<String, String> parameterMap, Object ... uriVariables) {
        return RestUtils.getForString(REST_TEMPLATE, url, parameterMap, uriVariables);
    }
}

