/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.web.method.handler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public class PrintRequestMappingHandler {
    private static final Logger log = LoggerFactory.getLogger(PrintRequestMappingHandler.class);

    @EventListener
    public void print(ApplicationReadyEvent event) {
        if (!log.isInfoEnabled()) {
            return;
        }
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map handlerMappingMap = applicationContext.getBeansOfType(RequestMappingInfoHandlerMapping.class);
        for (RequestMappingInfoHandlerMapping handlerMapping : handlerMappingMap.values()) {
            Map handlerMethods = handlerMapping.getHandlerMethods();
            handlerMethods.entrySet().stream().collect(Collectors.groupingBy(o -> ((HandlerMethod)o.getValue()).getBeanType())).forEach((clazz, entries) -> {
                String msg = this.formatMappings((Class<?>)clazz, (List<Map.Entry<RequestMappingInfo, HandlerMethod>>)entries);
                log.info(msg);
            });
        }
    }

    private String formatMappings(Class<?> userType, List<Map.Entry<RequestMappingInfo, HandlerMethod>> methods) {
        String formattedType = userType.getName();
        Function<Method, String> methodFormatter = method -> Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(",", "(", ")"));
        return methods.stream().map(e -> {
            Method method = ((HandlerMethod)e.getValue()).getMethod();
            return e.getKey() + ": " + method.getName() + (String)methodFormatter.apply(method);
        }).collect(Collectors.joining("\n    ", "\n    " + formattedType + ":\n    ", ""));
    }
}

