/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    public static final String UNKNOWN = "unknown";

    public static String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new BizRuntimeException("Thrown to indicate that the IP address of a host could not be determined", (Throwable)e);
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if ((StringUtils.isBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            ipAddress = IpUtils.getLocalIp();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String decodeIp(long ip) {
        if (ip <= 0L) {
            return "";
        }
        return String.valueOf(ip >> 24 & 0xFFL) + "." + (ip >> 16 & 0xFFL) + "." + (ip >> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    public static long encodeIp(String ipString) {
        String[] ipArray;
        long ipNumber = 0L;
        if (StringUtils.isNotBlank((CharSequence)ipString) && (ipArray = StringUtils.split((String)ipString, (String)".")).length == 4) {
            ipNumber = Long.parseLong(ipArray[0]) << 24 | Long.parseLong(ipArray[1]) << 16 | Long.parseLong(ipArray[2]) << 8 | Long.parseLong(ipArray[3]);
        }
        return ipNumber;
    }
}

