/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.web.servlet.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.util.StreamUtils;

public class EmptyBodyCheckingHttpInputMessage
implements HttpInputMessage {
    private final HttpHeaders headers;
    private final InputStream body;
    private final HttpMethod method;

    public EmptyBodyCheckingHttpInputMessage(HttpInputMessage inputMessage) throws IOException {
        this.headers = inputMessage.getHeaders();
        InputStream inputStream = inputMessage.getBody();
        if (inputStream.markSupported()) {
            inputStream.mark(1);
            this.body = inputStream.read() != -1 ? inputStream : null;
            inputStream.reset();
        } else {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
            int b = pushbackInputStream.read();
            if (b == -1) {
                this.body = null;
            } else {
                this.body = pushbackInputStream;
                pushbackInputStream.unread(b);
            }
        }
        this.method = ((HttpRequest)inputMessage).getMethod();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public InputStream getBody() {
        return this.body != null ? this.body : StreamUtils.emptyInput();
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public HttpMethod getMethod() {
        return this.method;
    }
}

