/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.utils;

import app.myoss.cloud.core.constants.MyossConstants;
import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.web.utils.RestRequestCallback;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class RestUtils {
    private static final Logger log = LoggerFactory.getLogger(RestUtils.class);

    public static <T> T exchange(RestTemplate restTemplate, HttpHeaders httpHeaders, MediaType contentType, URI uri, HttpMethod method, Object requestBody, Class<T> responseType, RestRequestCallback restRequestCallback) {
        if (contentType != null) {
            httpHeaders.setContentType(contentType);
        }
        if (restRequestCallback != null) {
            restRequestCallback.beforeRequest(restTemplate, uri, httpHeaders, method, requestBody, responseType);
        }
        HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)httpHeaders);
        log.info("requestUrl: {}, requestMethod: {}, requestBody: {}", new Object[]{uri, method, requestBody});
        long start = System.nanoTime();
        try {
            ResponseEntity responseEntity = restTemplate.exchange(uri, method, httpEntity, responseType);
            Object responseBody = responseEntity.getBody();
            long costTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            log.info("requestUrl: {}, costTime: {}, responseBody: {}", new Object[]{uri, costTime, responseBody});
            if (restRequestCallback != null) {
                responseBody = restRequestCallback.afterRequest(restTemplate, uri, method, httpEntity, responseType, responseBody);
            }
            return (T)responseBody;
        }
        catch (Exception e) {
            long costTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            if (e instanceof RestClientResponseException) {
                RestClientResponseException exception = (RestClientResponseException)e;
                String exceptionBody = exception.getResponseBodyAsString();
                if (log.isInfoEnabled()) {
                    log.warn("requestUrl: {}, requestMethod: {}, costTime: {}, exceptionBody: {}", new Object[]{uri, method, costTime, exceptionBody});
                } else {
                    log.warn("requestUrl: {}, requestMethod: {}, costTime: {}, requestBody: {}, exceptionBody: {}", new Object[]{uri, method, costTime, requestBody, exceptionBody});
                }
            } else if (log.isInfoEnabled()) {
                log.warn("requestUrl: {}, requestMethod: {}, costTime: {}", new Object[]{uri, method, costTime});
            } else {
                log.warn("requestUrl: {}, requestMethod: {}, costTime: {}, requestBody: {}", new Object[]{uri, method, costTime, requestBody});
            }
            if (restRequestCallback != null) {
                restRequestCallback.onThrowException(restTemplate, uri, method, httpEntity, responseType, e);
            }
            throw e;
        }
    }

    public static <T> T exchange(RestTemplate restTemplate, HttpHeaders httpHeaders, MediaType contentType, URI uri, HttpMethod method, Object requestBody, Class<T> responseType) {
        return RestUtils.exchange(restTemplate, httpHeaders, contentType, uri, method, requestBody, responseType, null);
    }

    public static <T> T exchange(RestTemplate restTemplate, MediaType contentType, URI uri, HttpMethod method, Object requestBody, Class<T> responseType) {
        return RestUtils.exchange(restTemplate, new HttpHeaders(), contentType, uri, method, requestBody, responseType);
    }

    public static <T> T exchange(RestTemplate restTemplate, MediaType contentType, String url, HttpMethod method, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        URI expanded = restTemplate.getUriTemplateHandler().expand(url, uriVariables);
        return RestUtils.exchange(restTemplate, contentType, expanded, method, requestBody, responseType);
    }

    public static String postJson(RestTemplate restTemplate, String url, String requestBody, Object ... uriVariables) {
        return RestUtils.exchange(restTemplate, MediaType.APPLICATION_JSON_UTF8, url, HttpMethod.POST, requestBody, String.class, uriVariables);
    }

    public static String postJson(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, String requestBody, Object ... uriVariables) {
        URI expanded = restTemplate.getUriTemplateHandler().expand(url, uriVariables);
        return RestUtils.exchange(restTemplate, httpHeaders, MediaType.APPLICATION_JSON_UTF8, expanded, HttpMethod.POST, requestBody, String.class);
    }

    public static String postForm(RestTemplate restTemplate, String url, LinkedMultiValueMap<String, String> requestBody, Object ... uriVariables) {
        return RestUtils.exchange(restTemplate, MediaType.APPLICATION_FORM_URLENCODED, url, HttpMethod.POST, requestBody, String.class, uriVariables);
    }

    public static String postForm(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, LinkedMultiValueMap<String, String> requestBody, Object ... uriVariables) {
        URI expanded = restTemplate.getUriTemplateHandler().expand(url, uriVariables);
        return RestUtils.exchange(restTemplate, httpHeaders, MediaType.APPLICATION_FORM_URLENCODED, expanded, HttpMethod.POST, requestBody, String.class);
    }

    public static <T> T getForObject(RestTemplate restTemplate, String url, Map<String, String> parameterMap, Class<T> responseType, Object ... uriVariables) {
        URI uri = RestUtils.uriBuild2(url, parameterMap, uriVariables).toUri();
        return RestUtils.exchange(restTemplate, null, uri, HttpMethod.GET, null, responseType);
    }

    public static <T> T getForObject(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, Map<String, String> parameterMap, Class<T> responseType, Object ... uriVariables) {
        URI uri = RestUtils.uriBuild2(url, parameterMap, uriVariables).toUri();
        return RestUtils.exchange(restTemplate, httpHeaders, null, uri, HttpMethod.GET, null, responseType);
    }

    public static String getForString(RestTemplate restTemplate, String url, Map<String, String> parameterMap, Object ... uriVariables) {
        return RestUtils.getForObject(restTemplate, url, parameterMap, String.class, uriVariables);
    }

    public static String getForString(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, Map<String, String> parameterMap, Object ... uriVariables) {
        return RestUtils.getForObject(restTemplate, httpHeaders, url, parameterMap, String.class, uriVariables);
    }

    public static String getForString(RestTemplate restTemplate, String url, Object ... uriVariables) {
        return RestUtils.exchange(restTemplate, null, url, HttpMethod.GET, null, String.class, uriVariables);
    }

    public static String getForString(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, Object ... uriVariables) {
        URI expanded = restTemplate.getUriTemplateHandler().expand(url, uriVariables);
        return RestUtils.exchange(restTemplate, httpHeaders, null, expanded, HttpMethod.GET, null, String.class);
    }

    public static <T> T getForObject(RestTemplate restTemplate, String url, LinkedMultiValueMap<String, String> parameterMap, Class<T> responseType, Object ... uriVariables) {
        URI uri = RestUtils.uriBuild(url, parameterMap, uriVariables).toUri();
        return RestUtils.exchange(restTemplate, null, uri, HttpMethod.GET, null, responseType);
    }

    public static <T> T getForObject(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, LinkedMultiValueMap<String, String> parameterMap, Class<T> responseType, Object ... uriVariables) {
        URI uri = RestUtils.uriBuild(url, parameterMap, uriVariables).toUri();
        return RestUtils.exchange(restTemplate, httpHeaders, null, uri, HttpMethod.GET, null, responseType);
    }

    public static String getForString(RestTemplate restTemplate, String url, LinkedMultiValueMap<String, String> parameterMap, Object ... uriVariables) {
        return RestUtils.getForObject(restTemplate, url, parameterMap, String.class, uriVariables);
    }

    public static String getForString(RestTemplate restTemplate, HttpHeaders httpHeaders, String url, LinkedMultiValueMap<String, String> parameterMap, Object ... uriVariables) {
        return RestUtils.getForObject(restTemplate, httpHeaders, url, parameterMap, String.class, uriVariables);
    }

    public static StringBuilder writeForm(Map<String, List<String>> form) {
        StringBuilder builder = new StringBuilder();
        String encode = MyossConstants.DEFAULT_CHARSET.name();
        Iterator<String> nameIterator = form.keySet().iterator();
        while (nameIterator.hasNext()) {
            String name = nameIterator.next();
            Iterator<String> valueIterator = form.get(name).iterator();
            while (valueIterator.hasNext()) {
                String value = valueIterator.next();
                try {
                    builder.append(URLEncoder.encode(name, encode));
                    if (value == null) continue;
                    builder.append('=');
                    builder.append(URLEncoder.encode(value, encode));
                    if (!valueIterator.hasNext()) continue;
                    builder.append('&');
                }
                catch (UnsupportedEncodingException e) {
                    throw new BizRuntimeException((Throwable)e);
                }
            }
            if (!nameIterator.hasNext()) continue;
            builder.append('&');
        }
        return builder;
    }

    public static StringBuilder writeForm2(Map<String, String> form) {
        StringBuilder builder = new StringBuilder();
        String encode = MyossConstants.DEFAULT_CHARSET.name();
        Iterator<Map.Entry<String, String>> entryIterator = form.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> next = entryIterator.next();
            String name = next.getKey();
            String value = next.getValue();
            if (value != null) {
                try {
                    builder.append(URLEncoder.encode(name, encode));
                    builder.append('=');
                    builder.append(URLEncoder.encode(value, encode));
                }
                catch (UnsupportedEncodingException e) {
                    throw new BizRuntimeException((Throwable)e);
                }
            }
            if (!entryIterator.hasNext()) continue;
            builder.append('&');
        }
        return builder;
    }

    public static UriComponents uriBuild(String url, Map<String, List<String>> parameterMap, Object ... uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (!CollectionUtils.isEmpty(parameterMap)) {
            for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
                String key = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    uriComponentsBuilder.queryParam(key, new Object[]{value});
                }
            }
        }
        return ArrayUtils.isNotEmpty((Object[])uriVariables) ? uriComponentsBuilder.buildAndExpand(uriVariables) : uriComponentsBuilder.build();
    }

    public static UriComponents uriBuild2(String url, Map<String, String> parameterMap, Object ... uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (!CollectionUtils.isEmpty(parameterMap)) {
            for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                uriComponentsBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return ArrayUtils.isNotEmpty((Object[])uriVariables) ? uriComponentsBuilder.buildAndExpand(uriVariables) : uriComponentsBuilder.build();
    }

    private RestUtils() {
    }
}

