/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.http.loadbalancer;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.web.util.UriComponentsBuilder;

public class ServiceRequestWrapper
extends HttpRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(ServiceRequestWrapper.class);
    private final ServiceInstance instance;
    private final LoadBalancerClient loadBalancer;

    public ServiceRequestWrapper(HttpRequest request, ServiceInstance instance, LoadBalancerClient loadBalancer) {
        super(request);
        this.instance = instance;
        this.loadBalancer = loadBalancer;
    }

    public URI getURI() {
        URI originUri = this.getRequest().getURI();
        log.trace("url before: {}", (Object)originUri);
        URI toUri = originUri;
        if ("lb".equals(originUri.getScheme())) {
            toUri = UriComponentsBuilder.fromUri((URI)originUri).scheme("http").build().toUri();
        }
        URI uri = this.loadBalancer.reconstructURI(this.instance, toUri);
        log.trace("url chosen: {}", (Object)uri);
        return uri;
    }
}

