/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.http.loadbalancer;

import app.myoss.cloud.web.http.loadbalancer.LoadBalancerClientRequestFactory;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class LoadBalancerClientRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancerClientRequestInterceptor.class);
    protected final LoadBalancerClient loadBalancer;
    protected final LoadBalancerClientRequestFactory requestFactory;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        URI originalUri = request.getURI();
        if (!"lb".equals(originalUri.getScheme())) {
            return execution.execute(request, body);
        }
        String serviceName = originalUri.getHost();
        Assert.state((serviceName != null ? 1 : 0) != 0, (String)("Request URI does not contain a valid hostname: " + originalUri));
        return (ClientHttpResponse)this.loadBalancer.execute(serviceName, this.requestFactory.createRequest(request, body, execution));
    }

    public LoadBalancerClientRequestInterceptor(LoadBalancerClient loadBalancer, LoadBalancerClientRequestFactory requestFactory) {
        this.loadBalancer = loadBalancer;
        this.requestFactory = requestFactory;
    }
}

