/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.boot;

import app.myoss.cloud.apm.spring.cloud.sleuth.trace.ApplicationEventTracer;
import app.myoss.cloud.core.constants.DeployEnvEnum;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;

public class BootApplication {
    public static String setStartDeployEnv(Logger logger, String deployEnvValue) {
        String deployEnv = StringUtils.isNotBlank((CharSequence)deployEnvValue) ? deployEnvValue : (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty("DEPLOY_ENV"), (CharSequence)System.getenv("DEPLOY_ENV"));
        logger.info("Starting application, DEPLOY_ENV: {}", (Object)deployEnv);
        if (StringUtils.isBlank((CharSequence)deployEnv)) {
            deployEnv = "dev";
            DeployEnvEnum.setDeployEnv((String)deployEnv);
            logger.info("DEPLOY_ENV set to {}", (Object)deployEnv);
        }
        return deployEnv;
    }

    public static String setStartDeployEnv(Logger logger) {
        return BootApplication.setStartDeployEnv(logger, null);
    }

    public static ConfigurableApplicationContext run(Logger logger, boolean setDeployEnv, String deployEnvValue, Class<?> source, String ... args) {
        boolean isDefaultTracerPresent = ClassUtils.isPresent((String)"brave.Tracing", (ClassLoader)BootApplication.class.getClassLoader());
        ApplicationEventTracer applicationEventTracer = null;
        if (isDefaultTracerPresent) {
            applicationEventTracer = new ApplicationEventTracer();
            applicationEventTracer.startApplication();
        }
        String deployEnv = null;
        if (setDeployEnv) {
            deployEnv = BootApplication.setStartDeployEnv(logger, deployEnvValue);
        }
        ConfigurableApplicationContext applicationContext = SpringApplication.run(source, (String[])args);
        if (setDeployEnv) {
            logger.info("Started application with args: {}, deployEnv: {}", (Object)Arrays.toString(args), (Object)deployEnv);
        } else {
            logger.info("Started application with args: {}", (Object)Arrays.toString(args));
        }
        if (isDefaultTracerPresent) {
            applicationEventTracer.startedApplication(applicationContext);
        }
        return applicationContext;
    }

    public static ConfigurableApplicationContext run(Logger logger, Class<?> source, String ... args) {
        return BootApplication.run(logger, true, null, source, args);
    }

    public static ConfigurableApplicationContext run(Logger logger, String deployEnvValue, Class<?> source, String ... args) {
        return BootApplication.run(logger, true, deployEnvValue, source, args);
    }

    public static ConfigurableApplicationContext run(Logger logger, boolean setDeployEnv, Class<?> source, String ... args) {
        return BootApplication.run(logger, setDeployEnv, null, source, args);
    }

    private BootApplication() {
    }
}

