/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.reactive.spring.web.server.filter;

import app.myoss.cloud.web.reactive.spring.web.method.error.ControllerDefaultErrorAttributes;
import app.myoss.cloud.web.reactive.utils.IpUtils;
import brave.Span;
import brave.internal.HexCodec;
import brave.propagation.TraceContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogWebRequestFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"WebRequest");
    public static final String MDC_START_TIME = "startTime";
    public static final String MDC_COST_TIME = "costTime";
    public static final String MDC_STATUS = "status";
    public static final String MDC_METHOD = "method";
    public static final String MDC_REQUEST_SERVER_INFO = "requestServerInfo";
    public static final String MDC_REQUEST_URL = "requestURL";
    public static final String MDC_REQUEST_URL_WITH_QUERY_STRING = "requestURLWithQueryString";
    public static final String MDC_REQUEST_URI = "requestURI";
    public static final String MDC_REQUEST_URI_WITH_QUERY_STRING = "requestURIWithQueryString";
    public static final String MDC_QUERY_STRING = "queryString";
    public static final String MDC_REMOTE_ADDR = "remoteAddr";
    public static final String MDC_REMOTE_REAL_IP = "remoteRealIp";
    public static final String MDC_REMOTE_HOST = "remoteHost";
    public static final String MDC_USER_AGENT = "userAgent";
    public static final String MDC_REFERRER = "referrer";
    private boolean logOnFilter = false;
    private boolean putRequestInfoToMDC = false;
    private String traceIdName;
    private String spanIdName;

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC) {
        this(logOnFilter, putRequestInfoToMDC, null, null);
    }

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC, String traceIdName, String spanIdName) {
        this.logOnFilter = logOnFilter;
        this.putRequestInfoToMDC = putRequestInfoToMDC;
        this.traceIdName = StringUtils.isNotBlank((CharSequence)traceIdName) ? traceIdName : "X-B3-TraceId";
        this.spanIdName = StringUtils.isNotBlank((CharSequence)spanIdName) ? spanIdName : "X-B3-SpanId";
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain filterChain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        long startNs = System.nanoTime();
        Date date = new Date();
        String time = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.putMDC(request, time);
        Object traceContext = exchange.getAttribute(TraceWebFilter.class.getName() + ".TRACE");
        if (traceContext != null) {
            Span span = (Span)traceContext;
            TraceContext context = span.context();
            String traceId = context.traceIdString();
            String spanId = HexCodec.toLowerHex((long)context.spanId());
            HttpHeaders responseHeaders = response.getHeaders();
            responseHeaders.add(this.traceIdName, traceId);
            responseHeaders.add(this.spanIdName, spanId);
            MDC.put((String)"X-B3-TraceId", (String)traceId);
            MDC.put((String)"X-B3-SpanId", (String)spanId);
        }
        return filterChain.filter(exchange).doOnError(throwable -> {
            Map<String, String> mdc = this.getMDCCopy();
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            this.putMDC(mdc, MDC_COST_TIME, String.valueOf(tookMs));
            HttpStatus httpStatus = ControllerDefaultErrorAttributes.determineHttpStatus(throwable);
            this.putMDC(mdc, MDC_STATUS, String.valueOf(httpStatus.value()));
            MDC.setContextMap(mdc);
            if (this.logOnFilter) {
                log.info("");
            }
            this.clearMDC();
        }).doOnSuccess(aVoid -> {
            Map<String, String> mdc = this.getMDCCopy();
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            this.putMDC(mdc, MDC_COST_TIME, String.valueOf(tookMs));
            this.putMDC(mdc, MDC_STATUS, String.valueOf(response.getStatusCode().value()));
            MDC.setContextMap(mdc);
            if (this.logOnFilter) {
                log.info("");
            }
            this.clearMDC();
        });
    }

    protected void putMDC(ServerHttpRequest request, String startTime) {
        Map<String, String> mdc = this.getMDCCopy();
        this.putMDC(mdc, MDC_START_TIME, startTime);
        if (!this.putRequestInfoToMDC) {
            MDC.setContextMap(mdc);
            return;
        }
        URI uri = request.getURI();
        HttpHeaders headers = request.getHeaders();
        this.putMDC(mdc, MDC_METHOD, request.getMethod().name());
        StringBuilder requestURL = new StringBuilder(uri.getScheme() + "://" + uri.getRawAuthority());
        this.putMDC(mdc, MDC_REQUEST_SERVER_INFO, requestURL.toString());
        String queryString = StringUtils.trimToNull((String)uri.getRawQuery());
        this.putMDC(mdc, MDC_REQUEST_URL, requestURL.append(uri.getRawPath()).toString());
        this.putMDC(mdc, MDC_REQUEST_URL_WITH_QUERY_STRING, uri.toString());
        String requestURI = uri.getRawPath();
        String requestURIWithQueryString = queryString != null ? requestURI + "?" + queryString : requestURI;
        this.putMDC(mdc, MDC_REQUEST_URI, requestURI);
        this.putMDC(mdc, MDC_REQUEST_URI_WITH_QUERY_STRING, requestURIWithQueryString);
        this.putMDC(mdc, MDC_QUERY_STRING, queryString);
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        if (remoteAddress != null && remoteAddress.getAddress() != null) {
            InetAddress address = remoteAddress.getAddress();
            this.putMDC(mdc, MDC_REMOTE_HOST, remoteAddress.getHostName());
            this.putMDC(mdc, MDC_REMOTE_ADDR, address.getHostAddress());
        }
        this.putMDC(mdc, MDC_REMOTE_REAL_IP, IpUtils.getIpAddress(request));
        this.putMDC(mdc, MDC_USER_AGENT, headers.getFirst("User-Agent"));
        this.putMDC(mdc, MDC_REFERRER, headers.getFirst("Referer"));
        MDC.setContextMap(mdc);
    }

    private void putMDC(Map<String, String> mdc, String key, String value) {
        if (value != null) {
            mdc.put(key, value);
        }
    }

    protected Map<String, String> getMDCCopy() {
        HashMap mdc = MDC.getCopyOfContextMap();
        if (mdc == null) {
            mdc = new HashMap(16);
        }
        return mdc;
    }

    public void clearMDC() {
        MDC.remove((String)MDC_START_TIME);
        MDC.remove((String)MDC_COST_TIME);
        MDC.remove((String)MDC_STATUS);
        if (this.putRequestInfoToMDC) {
            MDC.remove((String)MDC_METHOD);
            MDC.remove((String)MDC_REQUEST_URL);
            MDC.remove((String)MDC_REQUEST_URL_WITH_QUERY_STRING);
            MDC.remove((String)MDC_REQUEST_URI);
            MDC.remove((String)MDC_REQUEST_URI_WITH_QUERY_STRING);
            MDC.remove((String)MDC_QUERY_STRING);
            MDC.remove((String)MDC_REMOTE_ADDR);
            MDC.remove((String)MDC_REMOTE_REAL_IP);
            MDC.remove((String)MDC_REMOTE_HOST);
            MDC.remove((String)MDC_USER_AGENT);
            MDC.remove((String)MDC_REFERRER);
        }
    }
}

