/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.reactive.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;

public class IpUtils {
    public static final String UNKNOWN = "unknown";
    public static String[] PROXY_HEADER_KEYS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new BizRuntimeException("Thrown to indicate that the IP address of a host could not be determined", (Throwable)e);
        }
    }

    public static String getIpAddress(ServerHttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        String ipAddress = null;
        boolean flag = true;
        for (String key : PROXY_HEADER_KEYS) {
            List values = headers.get((Object)key);
            if (CollectionUtils.isEmpty((Collection)values) || !StringUtils.isNotBlank((CharSequence)(ipAddress = values.stream().filter(item -> !UNKNOWN.equalsIgnoreCase((String)item)).collect(Collectors.joining(","))))) continue;
            flag = false;
            break;
        }
        if (flag) {
            InetSocketAddress remoteAddress = request.getRemoteAddress();
            InetAddress address = remoteAddress != null ? remoteAddress.getAddress() : null;
            String string = ipAddress = address != null ? address.getHostAddress() : null;
            if (address == null || "127.0.0.1".equals(ipAddress) || "0:0:0:0:0:0:0:1".equals(ipAddress)) {
                ipAddress = IpUtils.getLocalIp();
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String decodeIp(long ip) {
        if (ip <= 0L) {
            return "";
        }
        return String.valueOf(ip >> 24 & 0xFFL) + "." + (ip >> 16 & 0xFFL) + "." + (ip >> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    public static long encodeIp(String ipString) {
        String[] ipArray;
        long ipNumber = 0L;
        if (StringUtils.isNotBlank((CharSequence)ipString) && (ipArray = StringUtils.split((String)ipString, (String)".")).length == 4) {
            ipNumber = Long.parseLong(ipArray[0]) << 24 | Long.parseLong(ipArray[1]) << 16 | Long.parseLong(ipArray[2]) << 8 | Long.parseLong(ipArray[3]);
        }
        return ipNumber;
    }
}

