/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.reactive.spring.web.server.filter;

import app.myoss.cloud.web.reactive.utils.IpUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogWebRequestFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"WebRequest");
    public static final String MDC_START_TIME = "startTime";
    public static final String MDC_COST_TIME = "costTime";
    public static final String MDC_STATUS = "status";
    public static final String MDC_METHOD = "method";
    public static final String MDC_REQUEST_SERVER_INFO = "requestServerInfo";
    public static final String MDC_REQUEST_URL = "requestURL";
    public static final String MDC_REQUEST_URL_WITH_QUERY_STRING = "requestURLWithQueryString";
    public static final String MDC_REQUEST_URI = "requestURI";
    public static final String MDC_REQUEST_URI_WITH_QUERY_STRING = "requestURIWithQueryString";
    public static final String MDC_QUERY_STRING = "queryString";
    public static final String MDC_REMOTE_ADDR = "remoteAddr";
    public static final String MDC_REMOTE_REAL_IP = "remoteRealIp";
    public static final String MDC_USER_AGENT = "userAgent";
    public static final String MDC_REFERRER = "referrer";
    private boolean logOnFilter = false;
    private boolean putRequestInfoToMDC = false;
    private FastDateFormat dateFormat;
    private String localIp;

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC) {
        this(logOnFilter, putRequestInfoToMDC, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC, String pattern) {
        this.logOnFilter = logOnFilter;
        this.putRequestInfoToMDC = putRequestInfoToMDC;
        this.dateFormat = FastDateFormat.getInstance((String)pattern, null, null);
        this.localIp = IpUtils.getLocalIp();
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain filterChain) {
        long startNs = System.nanoTime();
        Date date = new Date();
        return filterChain.filter(exchange).transformDeferred(call -> this.filter(exchange, (Mono<Void>)call, startNs, date));
    }

    private Mono<Void> filter(ServerWebExchange exchange, Mono<Void> call, long startNs, Date date) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        return call.doFinally(signalType -> {
            if (response.isCommitted()) {
                this.log(startNs, date, request, response);
            } else {
                response.beforeCommit(() -> {
                    this.log(startNs, date, request, response);
                    return Mono.empty();
                });
            }
        });
    }

    private void log(long startNs, Date date, ServerHttpRequest request, ServerHttpResponse response) {
        String time = this.dateFormat.format(date);
        this.putRequestInfo(request, time);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        this.putMDC(MDC_COST_TIME, String.valueOf(tookMs));
        HttpStatus httpStatus = response.getStatusCode();
        this.putMDC(MDC_STATUS, String.valueOf(httpStatus.value()));
        if (this.logOnFilter) {
            log.info("");
        }
        this.clearMDC();
    }

    protected void putRequestInfo(ServerHttpRequest request, String startTime) {
        this.putMDC(MDC_START_TIME, startTime);
        if (!this.putRequestInfoToMDC) {
            return;
        }
        URI uri = request.getURI();
        HttpHeaders headers = request.getHeaders();
        this.putMDC(MDC_METHOD, request.getMethod().name());
        StringBuilder requestURL = new StringBuilder(uri.getScheme() + "://" + uri.getRawAuthority());
        this.putMDC(MDC_REQUEST_SERVER_INFO, requestURL.toString());
        String queryString = StringUtils.isEmpty((CharSequence)uri.getRawQuery()) ? null : uri.getRawQuery();
        this.putMDC(MDC_REQUEST_URL, requestURL.append(uri.getRawPath()).toString());
        this.putMDC(MDC_REQUEST_URL_WITH_QUERY_STRING, uri.toString());
        String requestURI = uri.getRawPath();
        String requestURIWithQueryString = queryString != null ? requestURI + "?" + queryString : requestURI;
        this.putMDC(MDC_REQUEST_URI, requestURI);
        this.putMDC(MDC_REQUEST_URI_WITH_QUERY_STRING, requestURIWithQueryString);
        this.putMDC(MDC_QUERY_STRING, queryString);
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        InetAddress address = remoteAddress != null ? remoteAddress.getAddress() : null;
        String hostAddress = address != null ? address.getHostAddress() : null;
        this.putMDC(MDC_REMOTE_ADDR, hostAddress);
        String ipAddress = null;
        boolean flag = true;
        for (String key : IpUtils.PROXY_HEADER_KEYS) {
            List values = headers.get((Object)key);
            if (CollectionUtils.isEmpty((Collection)values) || !StringUtils.isNotBlank((CharSequence)(ipAddress = values.stream().filter(item -> !"unknown".equalsIgnoreCase((String)item)).collect(Collectors.joining(","))))) continue;
            flag = false;
            break;
        }
        if (flag && ((ipAddress = hostAddress) == null || "127.0.0.1".equals(ipAddress) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            ipAddress = this.localIp;
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        this.putMDC(MDC_REMOTE_REAL_IP, ipAddress);
        this.putMDC(MDC_USER_AGENT, headers.getFirst("User-Agent"));
        this.putMDC(MDC_REFERRER, headers.getFirst("Referer"));
    }

    private void putMDC(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        }
    }

    public void clearMDC() {
        MDC.remove((String)MDC_START_TIME);
        MDC.remove((String)MDC_COST_TIME);
        MDC.remove((String)MDC_STATUS);
        if (this.putRequestInfoToMDC) {
            MDC.remove((String)MDC_METHOD);
            MDC.remove((String)MDC_REQUEST_URL);
            MDC.remove((String)MDC_REQUEST_URL_WITH_QUERY_STRING);
            MDC.remove((String)MDC_REQUEST_URI);
            MDC.remove((String)MDC_REQUEST_URI_WITH_QUERY_STRING);
            MDC.remove((String)MDC_QUERY_STRING);
            MDC.remove((String)MDC_REMOTE_ADDR);
            MDC.remove((String)MDC_REMOTE_REAL_IP);
            MDC.remove((String)MDC_USER_AGENT);
            MDC.remove((String)MDC_REFERRER);
        }
    }
}

