/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.reactive.spring.web.method.error;

import app.myoss.cloud.apm.spring.cloud.sleuth.trace.ApplicationEventTracer;
import app.myoss.cloud.core.lang.json.JsonObject;
import app.myoss.cloud.web.reactive.spring.web.method.error.MonitorControllerProperties;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Component
public class ControllerDefaultErrorAttributes
implements ErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(ControllerDefaultErrorAttributes.class);
    private static final String ERROR_ATTRIBUTE = ControllerDefaultErrorAttributes.class.getName() + ".ERROR";
    @Autowired
    protected MonitorControllerProperties properties;

    public Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        Throwable error = this.getError(request);
        HttpStatus errorStatus = ControllerDefaultErrorAttributes.determineHttpStatus(error);
        URI requestUrl = request.uri();
        HttpMethod method = request.method();
        String contentType = request.headers().contentType().map(MimeType::getType).orElse(null);
        if (error instanceof RestClientResponseException) {
            RestClientResponseException exception = (RestClientResponseException)error;
            String responseBody = exception.getResponseBodyAsString();
            log.error("requestUrl: {}, requestMethod: {}, contentType: {}\norg.springframework.web.client.RestClientResponseException: {}, responseBody: {} ", new Object[]{requestUrl, method, contentType, exception.getMessage(), responseBody, error});
        } else {
            log.error("requestUrl: {}, requestMethod: {}, contentType: {}", new Object[]{requestUrl, method, contentType, error});
        }
        String traceId = ApplicationEventTracer.getTraceId();
        String errorCode = this.properties.getControllerExceptionErrorCode();
        String errorMsg = this.properties.getControllerExceptionErrorMsg();
        HashMap<String, String> errorValue = new HashMap<String, String>(1);
        errorValue.put("traceId", traceId);
        JsonObject errorAttributes = new JsonObject(5);
        errorAttributes.put("status", (Object)errorStatus.value());
        errorAttributes.put("success", (Object)false);
        errorAttributes.put("errorCode", (Object)errorCode);
        errorAttributes.put("errorMsg", (Object)errorMsg);
        errorAttributes.put("value", errorValue);
        return errorAttributes;
    }

    public Throwable getError(ServerRequest request) {
        return (Throwable)request.attribute(ERROR_ATTRIBUTE).orElseThrow(() -> new IllegalStateException("Missing exception attribute in ServerWebExchange"));
    }

    public void storeErrorInformation(Throwable error, ServerWebExchange exchange) {
        exchange.getAttributes().putIfAbsent(ERROR_ATTRIBUTE, error);
    }

    public static HttpStatus determineHttpStatus(Throwable error) {
        if (error instanceof ResponseStatusException) {
            return ((ResponseStatusException)error).getStatus();
        }
        ResponseStatus responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(error.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            return responseStatus.code();
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

