/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    public static final String UNKNOWN = "unknown";
    public static String[] PROXY_HEADER_KEYS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static String LOCAL_HOST_IP;

    public static String getLocalIp() {
        if (LOCAL_HOST_IP != null) {
            return LOCAL_HOST_IP;
        }
        try {
            LOCAL_HOST_IP = InetAddress.getLocalHost().getHostAddress();
            return LOCAL_HOST_IP;
        }
        catch (UnknownHostException e) {
            throw new BizRuntimeException("Thrown to indicate that the IP address of a host could not be determined", (Throwable)e);
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress = null;
        boolean flag = true;
        for (String key : PROXY_HEADER_KEYS) {
            ipAddress = request.getHeader(key);
            if (!StringUtils.isNotBlank((CharSequence)ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) continue;
            flag = false;
            break;
        }
        if (flag && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            ipAddress = IpUtils.getLocalIp();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String decodeIp(long ip) {
        if (ip <= 0L) {
            return "";
        }
        return String.valueOf(ip >> 24 & 0xFFL) + "." + (ip >> 16 & 0xFFL) + "." + (ip >> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    public static long encodeIp(String ipString) {
        String[] ipArray;
        long ipNumber = 0L;
        if (StringUtils.isNotBlank((CharSequence)ipString) && (ipArray = StringUtils.split((String)ipString, (String)".")).length == 4) {
            ipNumber = Long.parseLong(ipArray[0]) << 24 | Long.parseLong(ipArray[1]) << 16 | Long.parseLong(ipArray[2]) << 8 | Long.parseLong(ipArray[3]);
        }
        return ipNumber;
    }
}

