/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.web.servlet.filter;

import app.myoss.cloud.web.utils.IpUtils;
import brave.internal.codec.HexCodec;
import brave.propagation.TraceContext;
import io.opentracing.SpanContext;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.filter.OncePerRequestFilter;

public class LogWebRequestFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"WebRequest");
    public static final String MDC_START_TIME = "startTime";
    public static final String MDC_COST_TIME = "costTime";
    public static final String MDC_STATUS = "status";
    public static final String MDC_METHOD = "method";
    public static final String MDC_REQUEST_SERVER_INFO = "requestServerInfo";
    public static final String MDC_REQUEST_URL = "requestURL";
    public static final String MDC_REQUEST_URL_WITH_QUERY_STRING = "requestURLWithQueryString";
    public static final String MDC_REQUEST_URI = "requestURI";
    public static final String MDC_REQUEST_URI_WITH_QUERY_STRING = "requestURIWithQueryString";
    public static final String MDC_QUERY_STRING = "queryString";
    public static final String MDC_REMOTE_ADDR = "remoteAddr";
    public static final String MDC_REMOTE_REAL_IP = "remoteRealIp";
    public static final String MDC_USER_AGENT = "userAgent";
    public static final String MDC_REFERRER = "referrer";
    private boolean logOnFilter = false;
    private boolean putRequestInfoToMDC = false;
    private String traceIdName;
    private String spanIdName;
    private FastDateFormat dateFormat;

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC) {
        this(logOnFilter, putRequestInfoToMDC, null, null, "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public LogWebRequestFilter(boolean logOnFilter, boolean putRequestInfoToMDC, String traceIdName, String spanIdName, String pattern) {
        this.logOnFilter = logOnFilter;
        this.putRequestInfoToMDC = putRequestInfoToMDC;
        this.traceIdName = StringUtils.isNotBlank((CharSequence)traceIdName) ? traceIdName : "X-B3-TraceId";
        this.spanIdName = StringUtils.isNotBlank((CharSequence)spanIdName) ? spanIdName : "X-B3-SpanId";
        this.dateFormat = FastDateFormat.getInstance((String)pattern, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        long startNs = System.nanoTime();
        Date date = new Date();
        String time = this.dateFormat.format(date);
        try {
            this.putMDC(request, time);
            Object b3TraceContext = request.getAttribute("brave.propagation.TraceContext");
            if (b3TraceContext != null) {
                TraceContext context = (TraceContext)b3TraceContext;
                String traceId = context.traceIdString();
                String spanId = HexCodec.toLowerHex((long)context.spanId());
                response.addHeader(this.traceIdName, traceId);
                response.addHeader(this.spanIdName, spanId);
            } else {
                Object openTracingContext = request.getAttribute("io.opentracing.contrib.web.servlet.filter.TracingFilter.activeSpanContext");
                if (openTracingContext != null) {
                    SpanContext context = (SpanContext)openTracingContext;
                    String traceId = context.toTraceId();
                    String spanId = context.toTraceId();
                    response.addHeader(this.traceIdName, traceId);
                    response.addHeader(this.spanIdName, spanId);
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            this.putMDC(MDC_COST_TIME, String.valueOf(tookMs));
            this.putMDC(MDC_STATUS, String.valueOf(response.getStatus()));
            if (this.logOnFilter) {
                log.info("");
            }
            this.clearMDC();
        }
    }

    protected void putMDC(HttpServletRequest request, String startTime) {
        this.putMDC(MDC_START_TIME, startTime);
        if (!this.putRequestInfoToMDC) {
            return;
        }
        this.putMDC(MDC_METHOD, request.getMethod());
        this.putMDC(MDC_REQUEST_SERVER_INFO, request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort());
        StringBuilder requestURL = new StringBuilder(request.getRequestURL());
        String queryString = StringUtils.trimToNull((String)request.getQueryString());
        this.putMDC(MDC_REQUEST_URL, this.getRequestURL(requestURL, null));
        this.putMDC(MDC_REQUEST_URL_WITH_QUERY_STRING, this.getRequestURL(requestURL, queryString));
        String requestURI = request.getRequestURI();
        String requestURIWithQueryString = queryString != null ? requestURI + "?" + queryString : requestURI;
        this.putMDC(MDC_REQUEST_URI, requestURI);
        this.putMDC(MDC_REQUEST_URI_WITH_QUERY_STRING, requestURIWithQueryString);
        this.putMDC(MDC_QUERY_STRING, queryString);
        this.putMDC(MDC_REMOTE_ADDR, request.getRemoteAddr());
        this.putMDC(MDC_REMOTE_REAL_IP, IpUtils.getIpAddress(request));
        this.putMDC(MDC_USER_AGENT, request.getHeader("User-Agent"));
        this.putMDC(MDC_REFERRER, request.getHeader("Referer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestURL(StringBuilder requestURL, String queryString) {
        int length = requestURL.length();
        try {
            if (queryString != null) {
                requestURL.append('?').append(queryString);
            }
            String string = requestURL.toString();
            return string;
        }
        finally {
            requestURL.setLength(length);
        }
    }

    private void putMDC(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        }
    }

    public void clearMDC() {
        MDC.remove((String)MDC_START_TIME);
        MDC.remove((String)MDC_COST_TIME);
        MDC.remove((String)MDC_STATUS);
        if (this.putRequestInfoToMDC) {
            MDC.remove((String)MDC_METHOD);
            MDC.remove((String)MDC_REQUEST_URL);
            MDC.remove((String)MDC_REQUEST_URL_WITH_QUERY_STRING);
            MDC.remove((String)MDC_REQUEST_URI);
            MDC.remove((String)MDC_REQUEST_URI_WITH_QUERY_STRING);
            MDC.remove((String)MDC_QUERY_STRING);
            MDC.remove((String)MDC_REMOTE_ADDR);
            MDC.remove((String)MDC_REMOTE_REAL_IP);
            MDC.remove((String)MDC_USER_AGENT);
            MDC.remove((String)MDC_REFERRER);
        }
    }
}

