/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.web.spring.boot.config;

import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.web.spring.boot.config.FastJsonWebConfig;
import app.myoss.cloud.web.spring.web.servlet.filter.LogWebRequestFilter;
import app.myoss.cloud.web.spring.web.servlet.filter.ReaderBodyHttpServletRequestFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public abstract class AbstractWebMvcConfigurer
implements WebMvcConfigurer {
    @Qualifier(value="defaultFastJsonConfig")
    @Autowired
    private ObjectProvider<?> defaultFastJsonConfig;

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        FastJsonConfig fastJsonConfig;
        if (JsonApi.FASTJSON_PRESENT && (fastJsonConfig = (FastJsonConfig)this.defaultFastJsonConfig.getIfAvailable()) != null) {
            converters.add(3, (HttpMessageConverter<?>)FastJsonWebConfig.fastJsonHttpMessageConverter((FastJsonConfig)fastJsonConfig));
        }
    }

    @ConditionalOnMissingBean(name={"readerBodyHttpServletRequestFilter"})
    @Bean(name={"readerBodyHttpServletRequestFilter"})
    public FilterRegistrationBean<ReaderBodyHttpServletRequestFilter> readerBodyHttpServletRequestFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new ReaderBodyHttpServletRequestFilter());
        return registration;
    }

    @ConditionalOnMissingBean(name={"webRequestLogFilter"})
    @Bean(name={"webRequestLogFilter"})
    public FilterRegistrationBean<LogWebRequestFilter> webRequestLogFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new LogWebRequestFilter(true, true));
        registration.setOrder(100);
        return registration;
    }
}

