/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.code.format.eclipse;

import app.myoss.cloud.code.format.eclipse.imports.ImportsSorter;
import app.myoss.cloud.code.format.eclipse.utils.FileUtils;
import app.myoss.cloud.code.format.eclipse.utils.ImportsUtils;
import app.myoss.cloud.core.constants.PhoenixConstants;
import app.myoss.cloud.core.exception.BizRuntimeException;
import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.JavaVersion;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCodeFormatter {
    private static final Logger log = LoggerFactory.getLogger(JavaCodeFormatter.class);
    public static final Pattern TRAILING_SPACES = Pattern.compile("([^ \\t\\r\\n])[ \\t]+$", 8);
    public static final String JAVA_VERSION = JavaVersion.JAVA_RECENT.toString();
    protected DefaultCodeFormatter defaultCodeFormatter;
    protected ImportsSorter importsSorter;

    public JavaCodeFormatter(Properties properties, ImportsSorter importsSorter) {
        properties.setProperty("org.eclipse.jdt.core.compiler.source", JAVA_VERSION);
        properties.setProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", JAVA_VERSION);
        properties.setProperty("org.eclipse.jdt.core.compiler.compliance", JAVA_VERSION);
        this.defaultCodeFormatter = new DefaultCodeFormatter(this.toMap(properties));
        this.importsSorter = importsSorter;
    }

    public JavaCodeFormatter(URL formatConfigFile, String formatConfigFileProfile, ImportsSorter importsSorter) {
        this(FileUtils.readXmlJavaSettingsFile(formatConfigFile, formatConfigFileProfile), importsSorter);
    }

    public JavaCodeFormatter(String formatConfigFile, String formatConfigFileProfile, ImportsSorter importsSorter) {
        this(FileUtils.readXmlJavaSettingsFile(formatConfigFile, formatConfigFileProfile), importsSorter);
    }

    public JavaCodeFormatter(ImportsSorter importsSorter) {
        this(Objects.requireNonNull(JavaCodeFormatter.class.getClassLoader().getResource("eclipse-formatter-config/Default-Formatter-" + JAVA_VERSION + ".xml")), "Default", importsSorter);
    }

    public String formatText(StringBuilder fileContent) throws BadLocationException {
        int s0 = fileContent.indexOf("import ");
        if (s0 > -1) {
            int s1 = fileContent.lastIndexOf("import ");
            int s2 = fileContent.indexOf(";", s1);
            String importText = fileContent.substring(s0, s2 + 1);
            fileContent.delete(s0, s2 + 1);
            List<String> importList = ImportsUtils.trimImports(importText);
            String importTextSort = this.importsSorter.sort(importList);
            fileContent.insert(s0, importTextSort);
        }
        String text = fileContent.toString();
        Document doc = new Document();
        doc.set(text);
        int length = fileContent.length();
        TextEdit edit = this.defaultCodeFormatter.format(4104, text, 0, length, 0, "\n");
        edit.apply((IDocument)doc);
        String formatted = doc.get();
        Matcher matcher = TRAILING_SPACES.matcher(formatted);
        if (matcher.find()) {
            return matcher.replaceAll("$1");
        }
        return formatted;
    }

    public boolean formatFile(String filePath) {
        log.info("starting to format by eclipse formatter: {}", (Object)filePath);
        StringBuilder fileContent = new StringBuilder();
        File sourceFile = new File(filePath);
        try {
            com.google.common.io.Files.asCharSource((File)sourceFile, (Charset)PhoenixConstants.DEFAULT_CHARSET).copyTo((Appendable)fileContent);
        }
        catch (IOException ex) {
            throw new BizRuntimeException("read file: " + filePath, (Throwable)ex);
        }
        try {
            String formatted = this.formatText(fileContent);
            com.google.common.io.Files.asCharSink((File)sourceFile, (Charset)PhoenixConstants.DEFAULT_CHARSET, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)formatted);
            return true;
        }
        catch (Exception ex) {
            log.error("format by eclipse formatter failed: " + filePath, (Throwable)ex);
            return false;
        }
    }

    public List<String> formatDirectory(final String directoryPath) {
        try {
            final ArrayList<String> result = new ArrayList<String>();
            Files.walkFileTree(Paths.get(directoryPath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String filePath = file.toString();
                    if (!filePath.endsWith(".java")) {
                        return FileVisitResult.CONTINUE;
                    }
                    boolean isFormat = JavaCodeFormatter.this.formatFile(filePath);
                    if (!isFormat) {
                        result.add("\u683c\u5f0f\u5316\u5931\u8d25: " + filePath.substring(directoryPath.length()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return result;
        }
        catch (IOException ex) {
            throw new BizRuntimeException("read directory: " + directoryPath, (Throwable)ex);
        }
    }

    private Map<String, String> toMap(Properties properties) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            options.put(name, properties.getProperty(name));
        }
        return options;
    }
}

