/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.code.format.eclipse.imports.impl;

import app.myoss.cloud.code.format.eclipse.utils.ImportsUtils;
import java.util.Comparator;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportsComparator
implements Comparator<String> {
    private static final Logger log = LoggerFactory.getLogger(ImportsComparator.class);

    @Override
    public int compare(String o1, String o2) {
        String simpleName2;
        String containerName2;
        String simpleName1 = this.simpleName(o1);
        String containerName1 = this.getPackage(o1, simpleName1);
        int i = containerName1.compareTo(containerName2 = this.getPackage(o2, simpleName2 = this.simpleName(o2)));
        if (i == 0) {
            i = simpleName1.compareTo(simpleName2);
        }
        return i;
    }

    private String getPackage(String qualified, String simple) {
        String substring = qualified.length() > simple.length() ? qualified.substring(0, qualified.length() - simple.length() - 1) : ImportsUtils.getPackage(qualified);
        return substring;
    }

    private String simpleName(String qualified) {
        Class<?> clazz = this.getClass(qualified);
        if (clazz != null) {
            Class<?> containingClass = clazz;
            StringBuilder simpleName = new StringBuilder(clazz.getSimpleName());
            while (containingClass != null && containingClass.getDeclaringClass() != null) {
                if ((containingClass = containingClass.getDeclaringClass()) == null) continue;
                simpleName.insert(0, containingClass.getSimpleName() + ".");
            }
            return simpleName.toString();
        }
        return ImportsUtils.getSimpleName(qualified);
    }

    private Class<?> getClass(String qualified) {
        try {
            return ClassUtils.getClass((String)qualified);
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

