/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.code.format.eclipse.imports.impl;

import app.myoss.cloud.code.format.eclipse.imports.ImportsSorter;
import app.myoss.cloud.code.format.eclipse.imports.impl.ImportsComparator;
import app.myoss.cloud.code.format.eclipse.utils.ImportsUtils;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ImportsSorter452
implements ImportsSorter {
    private List<String> importOrder = new ArrayList<String>();
    private Set<String> allImportOrderItems = new HashSet<String>();
    private Comparator<? super String> importsComparator;

    public ImportsSorter452(List<String> importOrder, ImportsComparator comparator) {
        this.importsComparator = comparator;
        List<String> importOrderCopy = importOrder != null ? new ArrayList<String>(importOrder) : this.defaultOrder();
        this.normalizeStaticOrderItems(importOrderCopy);
        this.putStaticItemIfNotExists(importOrderCopy);
        this.importOrder.addAll(importOrderCopy);
        this.allImportOrderItems.addAll(importOrderCopy);
    }

    public ImportsSorter452(ImportsComparator comparator) {
        this(null, comparator);
    }

    @Override
    public String sort(List<String> imports) {
        ArrayList<String> template = new ArrayList<String>(this.importOrder);
        ArrayListMultimap matchingImports = ArrayListMultimap.create();
        ArrayList<String> notMatching = new ArrayList<String>();
        this.filterMatchingImports((ArrayListMultimap<String, String>)matchingImports, notMatching, imports);
        this.mergeMatchingItems(template, (ArrayListMultimap<String, String>)matchingImports);
        this.mergeNotMatchingItems(template, notMatching);
        this.removeNewLines(template);
        return ImportsUtils.getImportResult(template);
    }

    private void removeNewLines(List<String> template) {
        ArrayList<String> temp = new ArrayList<String>();
        boolean previousWasNewLine = false;
        boolean anyContent = false;
        for (String s : template) {
            if (!anyContent && s.equals("\n")) continue;
            if (s.equals("\n")) {
                if (previousWasNewLine) continue;
                temp.add(s);
                previousWasNewLine = true;
                continue;
            }
            previousWasNewLine = false;
            anyContent = true;
            temp.add(s);
        }
        Collections.reverse(temp);
        List<String> temp2 = this.trimNewLines(temp);
        Collections.reverse(temp2);
        template.clear();
        template.addAll(temp2);
    }

    private List<String> trimNewLines(List<String> temp) {
        ArrayList<String> temp2 = new ArrayList<String>();
        boolean anyContent = false;
        for (String s : temp) {
            if (!anyContent && s.equals("\n")) continue;
            anyContent = true;
            temp2.add(s);
        }
        return temp2;
    }

    private void putStaticItemIfNotExists(List<String> allImportOrderItems) {
        boolean contains = false;
        for (String allImportOrderItem : allImportOrderItems) {
            if (!"static ".equals(allImportOrderItem)) continue;
            contains = true;
        }
        if (!contains) {
            allImportOrderItems.add(0, "static ");
        }
    }

    private void normalizeStaticOrderItems(List<String> allImportOrderItems) {
        for (int i = 0; i < allImportOrderItems.size(); ++i) {
            String s = allImportOrderItems.get(i);
            if (!s.startsWith("\\#") && !s.startsWith("#")) continue;
            allImportOrderItems.set(i, s.replace("\\#", "static ").replace("#", "static "));
        }
    }

    private void filterMatchingImports(ArrayListMultimap<String, String> matchingImports, ArrayList<String> notMatching, List<String> imports) {
        for (String anImport : imports) {
            String orderItem = this.getBestMatchingImportOrderItem(anImport);
            if (orderItem != null) {
                matchingImports.put((Object)orderItem, (Object)anImport);
                continue;
            }
            notMatching.add(anImport);
        }
        notMatching.addAll(this.allImportOrderItems);
    }

    private String getBestMatchingImportOrderItem(String anImport) {
        String matchingImport = null;
        for (String orderItem : this.allImportOrderItems) {
            if (!anImport.startsWith("static ".equals(orderItem) || "".equals(orderItem) ? orderItem : orderItem + ".")) continue;
            if (matchingImport == null) {
                matchingImport = orderItem;
                continue;
            }
            matchingImport = ImportsUtils.betterMatching(matchingImport, orderItem, anImport);
        }
        return matchingImport;
    }

    private void mergeNotMatchingItems(List<String> template, ArrayList<String> notMatching) {
        notMatching.sort(this.importsComparator);
        template.add("\n");
        for (String notMatchingItem : notMatching) {
            boolean isOrderItem;
            if (!this.matchesStatic(false, notMatchingItem) || (isOrderItem = this.isOrderItem(notMatchingItem, false))) continue;
            template.add(notMatchingItem);
        }
        template.add("\n");
    }

    private boolean isOrderItem(String notMatchingItem, boolean staticItems) {
        boolean contains = this.allImportOrderItems.contains(notMatchingItem);
        return contains && this.matchesStatic(staticItems, notMatchingItem);
    }

    private boolean matchesStatic(boolean staticItems, String notMatchingItem) {
        boolean isStatic = notMatchingItem.startsWith("static ");
        return isStatic && staticItems || !isStatic && !staticItems;
    }

    private void mergeMatchingItems(List<String> template, ArrayListMultimap<String, String> matchingImports) {
        for (int i = 0; i < template.size(); ++i) {
            String item = template.get(i);
            if (!this.allImportOrderItems.contains(item)) continue;
            List strings = matchingImports.get((Object)item);
            if (strings == null || strings.isEmpty()) {
                template.remove(i);
                --i;
                continue;
            }
            ArrayList<? super String> matchingItems = new ArrayList<String>(strings);
            matchingItems.sort(this.importsComparator);
            template.remove(i);
            if (i != 0 && !template.get(i - 1).equals("\n")) {
                template.add(i, "\n");
                ++i;
            }
            if (i + 1 < template.size() && !template.get(i + 1).equals("\n") && !template.get(i).equals("\n")) {
                template.add(i, "\n");
            }
            template.addAll(i, matchingItems);
            if (i == 0 || template.get(i - 1).equals("\n")) continue;
            template.add(i, "\n");
        }
        if (template.size() > 0 && template.get(template.size() - 1).equals("\n")) {
            template.remove(template.size() - 1);
        }
    }
}

