/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.code.format.eclipse.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties readXmlJavaSettingsFile(URL formatConfigFile, String formatConfigFileProfile) {
        Properties properties = new Properties();
        try (InputStream inputStream = formatConfigFile.openStream();){
            Properties properties2 = FileUtils.readXmlJavaSettingsFile(inputStream, properties, formatConfigFileProfile);
            return properties2;
        }
        catch (IOException ex) {
            throw new BizRuntimeException("read file: " + formatConfigFile, (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties readXmlJavaSettingsFile(String formatConfigFile, String formatConfigFileProfile) {
        Properties properties = new Properties();
        File file = new File(formatConfigFile);
        try (FileInputStream inputStream = new FileInputStream(file);){
            Properties properties2 = FileUtils.readXmlJavaSettingsFile(inputStream, properties, formatConfigFileProfile);
            return properties2;
        }
        catch (IOException ex) {
            throw new BizRuntimeException("read file: " + formatConfigFile, (Throwable)ex);
        }
    }

    public static Properties readXmlJavaSettingsFile(InputStream file, Properties properties, String profile) {
        int defaultSize = properties.size();
        if (profile == null) {
            throw new IllegalStateException("no profile selected, go to settings and select proper settings file");
        }
        boolean profileFound = false;
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            doc.getDocumentElement().normalize();
            NodeList profiles = doc.getElementsByTagName("profile");
            if (profiles.getLength() == 0) {
                throw new IllegalStateException("loading of profile settings failed, file does not contain any profiles");
            }
            for (int temp = 0; temp < profiles.getLength(); ++temp) {
                Element profileElement;
                String name;
                Node profileNode = profiles.item(temp);
                if (profileNode.getNodeType() != 1 || !profile.equals(name = (profileElement = (Element)profileNode).getAttribute("name"))) continue;
                profileFound = true;
                NodeList childNodes = profileElement.getElementsByTagName("setting");
                if (childNodes.getLength() == 0) {
                    throw new IllegalStateException("loading of profile settings failed, profile has no settings elements");
                }
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node item = childNodes.item(i);
                    if (item.getNodeType() != 1) continue;
                    Element attributeItem = (Element)item;
                    String id = attributeItem.getAttribute("id");
                    String value = attributeItem.getAttribute("value");
                    properties.setProperty(id.trim(), value.trim());
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        if (!profileFound) {
            throw new IllegalStateException("profile not found in the file " + file);
        }
        if (properties.size() == defaultSize) {
            throw new IllegalStateException("no properties loaded, something is broken, file:");
        }
        return properties;
    }
}

