/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.code.format.eclipse.utils;

import app.myoss.cloud.core.constants.MyossConstants;
import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;

public class ImportsUtils {
    public static final String N = "\n";

    public static String getSimpleName(String qualified) {
        int lastDot = qualified.lastIndexOf(".");
        if (lastDot == -1) {
            return qualified;
        }
        return qualified.substring(lastDot + 1, qualified.length());
    }

    public static String getPackage(String qualified) {
        int lastDot = qualified.lastIndexOf(".");
        if (lastDot == -1) {
            return "";
        }
        return qualified.substring(0, lastDot);
    }

    public static List<String> trimImports(String imports) {
        String[] split = imports.split(N);
        HashSet<String> strings = new HashSet<String>();
        for (String s : split) {
            if (!s.startsWith("import ")) continue;
            s = s.substring(7, s.indexOf(";"));
            strings.add(s);
        }
        return new ArrayList<String>(strings);
    }

    public static String betterMatching(String order1, String order2, String anImport) {
        if (order1.equals(order2)) {
            throw new IllegalArgumentException("orders are same");
        }
        for (int i = 0; i < anImport.length() - 1; ++i) {
            if (order1.length() - 1 == i && order2.length() - 1 != i) {
                return order2;
            }
            if (order2.length() - 1 == i && order1.length() - 1 != i) {
                return order1;
            }
            char orderChar1 = order1.length() != 0 ? (char)order1.charAt(i) : (char)' ';
            char orderChar2 = order2.length() != 0 ? (char)order2.charAt(i) : (char)' ';
            char importChar = anImport.charAt(i);
            if (importChar == orderChar1 && importChar != orderChar2) {
                return order1;
            }
            if (importChar == orderChar1 || importChar != orderChar2) continue;
            return order2;
        }
        return null;
    }

    public static String getImportResult(List<String> template) {
        StringBuilder strings = new StringBuilder();
        for (String s : template) {
            if (s.equals(N)) {
                strings.append(s);
                continue;
            }
            strings.append("import ").append(s).append(";").append(N);
        }
        return strings.deleteCharAt(strings.length() - 1).toString();
    }

    public static Properties readPropertiesFile(String file) {
        Properties formatterOptions;
        try (InputStream stream = ImportsUtils.class.getClassLoader().getResourceAsStream(file);){
            formatterOptions = new Properties();
            String s = StreamUtil.copyToString((InputStream)stream, (Charset)MyossConstants.DEFAULT_CHARSET);
            StringReader reader = new StringReader(s.replace("=\\#", "=#"));
            formatterOptions.load(reader);
        }
        catch (IOException ex) {
            throw new BizRuntimeException("config file read error", (Throwable)ex);
        }
        return formatterOptions;
    }

    public static List<String> loadImportOrderFile(Properties file) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.parseInt(o1) - Integer.parseInt(o2);
            }
        });
        treeMap.putAll(file);
        return new ArrayList<String>(treeMap.values());
    }

    private ImportsUtils() {
    }
}

