/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.aspectj;

import app.myoss.cloud.datasource.routing.aspectj.DataSourceMethodPointcutAdvisorBuilder;
import app.myoss.cloud.datasource.routing.aspectj.DataSourcePointcutAdvisor;
import app.myoss.cloud.datasource.routing.config.DataSourceProperty;
import app.myoss.cloud.datasource.routing.spring.boot.autoconfigure.DataSourceRoutingProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.util.CollectionUtils;

public class DataSourceMethodPointcutAdvisorDynamicBeanRegistry
implements BeanDefinitionRegistryPostProcessor {
    private DataSourceRoutingProperties dataSourceRoutingProperties;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.dataSourceRoutingProperties == null || CollectionUtils.isEmpty(this.dataSourceRoutingProperties.getDatabases())) {
            return;
        }
        LinkedHashMap allMethodPointcuts = this.dataSourceRoutingProperties.getDatabases().stream().filter(database -> !CollectionUtils.isEmpty(database.getMethodPointcuts())).collect(Collectors.toMap(DataSourceProperty::getName, DataSourceProperty::getMethodPointcuts, (k, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", k));
        }, LinkedHashMap::new));
        if (CollectionUtils.isEmpty((Map)allMethodPointcuts)) {
            return;
        }
        int pointCutOrder = this.dataSourceRoutingProperties.getDataSourcePointcutAdvisorOrder() - 1;
        List<DataSourcePointcutAdvisor> pointcutAdvisors = DataSourceMethodPointcutAdvisorBuilder.create(allMethodPointcuts, pointCutOrder);
        for (int i = 0; i < pointcutAdvisors.size(); ++i) {
            DataSourcePointcutAdvisor pointcutAdvisor = pointcutAdvisors.get(i);
            String dataSourceBeanName = pointcutAdvisor.getName() + DataSourcePointcutAdvisor.class.getSimpleName() + i;
            AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(DataSourcePointcutAdvisor.class, () -> pointcutAdvisor).getRawBeanDefinition();
            registry.registerBeanDefinition(dataSourceBeanName, (BeanDefinition)beanDefinition);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setDataSourceRoutingProperties(DataSourceRoutingProperties dataSourceRoutingProperties) {
        this.dataSourceRoutingProperties = dataSourceRoutingProperties;
    }
}

