/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.context;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceNameContextHolder {
    private static final Logger log = LoggerFactory.getLogger(DataSourceNameContextHolder.class);
    private static final ThreadLocal<Deque<String>> DATA_SOURCE_NAME_CONTEXT = ThreadLocal.withInitial(ArrayDeque::new);

    public static void push(String dataSourceName) {
        Deque<String> deque = DATA_SOURCE_NAME_CONTEXT.get();
        String name = StringUtils.isBlank((CharSequence)dataSourceName) ? "" : dataSourceName;
        deque.push(name);
    }

    public static String peek() {
        Deque<String> deque = DATA_SOURCE_NAME_CONTEXT.get();
        return deque.peek();
    }

    public static String pop() {
        Deque<String> deque = DATA_SOURCE_NAME_CONTEXT.get();
        String dataSourceName = deque.poll();
        if (deque.isEmpty()) {
            DATA_SOURCE_NAME_CONTEXT.remove();
        }
        return dataSourceName;
    }

    public static void clear() {
        DATA_SOURCE_NAME_CONTEXT.remove();
    }

    private DataSourceNameContextHolder() {
    }
}

